(in-package 'twdp)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'xcw)
(require :loop)
(use-package 'cw)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *tileworld-window* "Use MAKE-TILEWORLD-WINDOW to initialize")
(defvar *last-char*     NIL)
(defvar *carray-string*    (make-string 4000))
(defconstant *display-columns*  80)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun init-display ()
  (make-tileworld-window)
  (clear *tileworld-window*)
  (clear-input *tileworld-window*)
  (setf *last-char* NIL))

(defun make-window ()
  (setq *tileworld-window*
		(make-window-stream :left 532
							:bottom (- 800 (* (font-character-height *system-font*)
											  24))
							:lines-high 24
							:chars-wide 80
							:activate-p t))
  (enable-window-stream-event-handling *tileworld-window*)
  (values))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun clear-display ()
  (clear *tileworld-window*))

(defun refresh-display ()
  (values))

(defun close-display ()
  (flush *tileworld-window*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun display-char (c row col)
  (display-string (string c) row col))

(defun display-string-prefix-wrapped (str chars-to-print row col)
  (cond 
   ((<= chars-to-print 0) (values))
   (T (let ((chars-this-line (min chars-to-print (- (+ *display-columns* 1) col))))
		(display-string-single-line str chars-this-line row col)
		(display-string-prefix-wrapped
		 (subseq str chars-this-line)
		 (- chars-to-print chars-this-line) 
		 (+ row 1)
		 1)))))

(defun display-string-single-line (str chars row col)
  (multiple-value-bind (x y) 
					   (rowcol->xy row col)
	(draw-string-xy *tileworld-window* 
					x
					y
					(subseq str 0 chars))))

(defun display-string-wrapped (str row col)
  (display-string-prefix-wrapped str (length str) row col))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun carray->string! (carray)
  (let* ((rows (array-dimension carray 0))
		 (cols (array-dimension carray 1))
		 (string-index 0))
	(loop for r from 0 to (- rows 1)
		  do (loop for c from 0 to (- cols 1)
				   do (setf (aref *carray-string* string-index)
							(aref carray r c))
				      (setf string-index (+ string-index 1))))
	*carray-string*))

(defun display-carray (aray row col)
  (display-string-prefix-wrapped (carray->string! aray) 
									  (array-total-size aray)
									  row
									  col))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun get-char ()
  (cond
   ((not (null *last-char*))
	  (prog1 *last-char*
		     (setf *last-char* NIL)))
   (t (read-char *tileworld-window*))))

(defun char-in-buffer? ()
  (cond 
   ((not (null *last-char*)) 1)
   (t (setf *last-char* (read-char-no-hang *tileworld-window*))
	  (if (null *last-char*) 0 1))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun rowcol->xy (row col)
  (values
   (* (+ col 1) (font-character-width *system-font*))	        ;x in pixels
   (- (window-stream-inner-height *tileworld-window*)   ;y in pixels, from Up Left
	  (* (+ row 1) (font-character-height *system-font*)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; initializations go here
(eval-when (load eval)
           (cw:initialize-common-windows)
		   (setf *system-font* (cw:open-font :courier :normal 10)))

