(require 'loop)
(use-package :loop)

(defvar *tileworld-dir* "~/tileworld")
(defvar *tileworld-world-dir* "~/tileworld/world-code")
(defvar *tileworld-agent-dir* "~/tileworld/agent-code")
(defvar *tileworld-environments-dir* "~/tileworld/environments")

(defun load-file-with-dir (dir file)
  (load (merge-pathnames (make-pathname :directory dir)
						 (make-pathname :name file))))

(defun load-file-list-with-dir (dir file-list)
  (cond
   ((null file-list) (values))
   (t (load-file-with-dir dir (car file-list))
	  (load-file-list-with-dir dir (cdr file-list)))))

(defun load-files-with-dir (dir &rest files)
  (load-file-list-with-dir dir files))

(defun load-world ()
  (load-files-with-dir *tileworld-world-dir* 
                       "tw-vars"
                       "twdisp"
                       "tw-interface"
                       "save-history"
                       "tw"))

(defun load-agent ()
  (load-files-with-dir *tileworld-agent-dir*
                                        ;                       "heap.o"
                                        ;                       "bfs.o" 
                                        ;                       "twmove.o" 
                                        ;                       "twpush.o" 
                       "pplan"
                       "agent-structures"
                       "agent"
                       "agent-access"
                       "temp"
                       "exper"
                       "parms"
                       "ex"))

(defun load-foreign()(load 
                      (concatenate 'string *tileworld-agent-dir* "/heap.o") 
                      :foreign-files 
                       (list
                        (concatenate 'string *tileworld-agent-dir* "/bfs.o")
                        (concatenate 'string *tileworld-agent-dir* "/twmove.o")
                        (concatenate 'string *tileworld-agent-dir* "/twpush.o")
                         )))

(defun load-env ()
  (load-files-with-dir *tileworld-environments-dir*
                       "defaults.cl"
                    ;   "ctw.cl"
                       ))

(defun load-all () 
          (load-world)
          (load-agent)
          (load-foreign)
          (load-env)
          (use-package 'ff)
          (ff:defforeign 'moveplan :arguments '(fixnum fixnum string string 
                                                fixnum fixnum)
                         :return-type :lisp)
          (ff:defforeign 'pushplan :arguments '(fixnum fixnum string string 
                                                fixnum fixnum fixnum)
                         :return-type :lisp))

(load-all)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; buffer is to hold strings passed from C to lisp 
; see Allegro manual 10.5
; Badr

(defconstant *max-string-length* 10000)
(defvar *lisp-string-buffer* (make-string *max-string-length*))
(defvar *lisp-string-buffer-index* (ff:register-value '*lisp-string-buffer*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Compile code

(defun compile-file-with-dir (dir file)
  (compile-file (merge-pathnames (make-pathname :directory dir)
						 (make-pathname :name file))))

(defun compile-file-list-with-dir (dir file-list)
  (cond
   ((null file-list) (values))
   (t (compile-file-with-dir dir (car file-list))
	  (compile-file-list-with-dir dir (cdr file-list)))))

(defun compile-files-with-dir (dir &rest files)
  (compile-file-list-with-dir dir files))

(defun compile-world ()
  (compile-files-with-dir *tileworld-world-dir* 
                       "tw-vars"
                       "twdisp"
                       "tw"
                       "tw-interface"
                       "save-history"))

(defun compile-agent ()
  (compile-files-with-dir *tileworld-agent-dir*
                          "agent-structures"
                          "agent-access"
                          "pplan"
                          "agent"
                          "ex"))
                          