/*  twmove.c - plan a path for the tile-world agent.   MNR 8/3/89.

    Assumes single-cell agent and tiles, and that holes are obstacles.

    Interface:
	moveplan(xmax,ymax,grid,occupied,source_x,source_y)
        --> returns a null-terminated string of udlr's, or 'x' if no path.

    where
        - grid is an array of xmax*ymax characters.  D's are destinations.
	- occupied[ch] == 1 iff occupied by obstacle

    Parameters to bfs: 
        Search space is xmax*ymax
	4 transitions: udlr
	4 ways to enter a given x,y.

*/

/* #include "/usr/cs/include/libc.h"*/
#include <curses.h>
#include <signal.h>
#include "/srv/fs0/allegrocl/lib/misc/lisp.h"

int xmax,ymax;
char *grid,*occupied,*shown;

char *moveplan(xmax1,ymax1,grid1,occupied1,source_x,source_y)
   int xmax1,ymax1,source_x,source_y;
   char *grid1,*occupied1;

{   /* this code is to facilitate returning strings to Lisp */
    int stbuf_index;
    /* */
    int x,y,source,path_source,path_length,*path,
        is_dest(),gen_trans(),inv_trans();
    short int source_cost,path_cost;
    char *malloc(),*moves;

    stbuf_index = 0;

    xmax=xmax1;
    ymax=ymax1;
    grid=grid1;
    occupied=occupied1;

    source=source_x*ymax+source_y;
    source_cost=0;

    bfs(xmax*ymax,4,1,&source,&source_cost,is_dest,gen_trans,inv_trans,
        &path_source,&path_length,&path,&path_cost);
    if (path_length==-1) {
	moves=malloc(2);
	*moves='x';
	*(moves+1)=0;
    } else {
	moves=malloc(path_length+1);
	for(x=0;x<path_length;++x) {
	    switch(path[x]) {
		case 0: *(moves+x)='u'; break;
		case 1: *(moves+x)='d'; break;
		case 2: *(moves+x)='l'; break;
		case 3: *(moves+x)='r'; break;
	    }
	}
	*(moves+path_length)=0;
    }
    strcpy((char *) Vecdata(SymbolValue(lisp_value(stbuf_index))),moves);
    return (char *) SymbolValue(lisp_value(stbuf_index));

    /* return moves; */
}

is_dest(pos)
    int pos;
{
    return grid[pos]=='D';
}


gen_trans(state,new_states,new_costs)
    int state,*new_states;
    short int *new_costs;
{
    int i;

    for (i=0;i<4;++i)
        trans_fn(state,i,new_states+i,new_costs+i);
}


trans_fn(state,transition,new_state_p,cost_p)
    int state,transition,*new_state_p;
    short int *cost_p;
{
    switch(transition) {
	case 0:			/* u */
	    (*new_state_p)=state-xmax;
	    if (occupied[*(grid+*new_state_p)])
	        (*new_state_p)= -1;
	    *cost_p=1;
	    break;
	case 1:			/* d */
	    (*new_state_p)=state+xmax;
	    if (occupied[*(grid+*new_state_p)])
	        (*new_state_p)= -1;
	    *cost_p=1;
	    break;
	case 2:			/* l */
	    (*new_state_p)=state-1;
	    if (occupied[*(grid+*new_state_p)])
	        (*new_state_p)= -1;
	    *cost_p=1;
	    break;
	case 3:			/* r */
	    (*new_state_p)=state+1;
	    if (occupied[*(grid+*new_state_p)])
	        (*new_state_p)= -1;
	    *cost_p=1;
	    break;
    }
}


inv_trans(state_p,transition,new_state)
    int *state_p,transition,new_state;
{
    short int garbage;

    trans_fn(new_state,transition^1,state_p,&garbage);
}
