
;parms.l ---

;;;agents are named as follows:
;  a
;  n (normal speed) / f (fast, 10x, speed)
;  e (seu evaluate) / s (simple evaluate)
;  # (threshhold setting)

(setf ane
  (make-agent
   :name 'ane
   :think-strategy 'deliberate-first
   :act-time 200
   :eval-strat 'seu-evaluate
   :wait-time 1000
   :threshhold 0))

(setf ans
  (make-agent
   :name 'ans
   :think-strategy 'deliberate-first
   :act-time 200
   :eval-strat 'simple-evaluate
   :wait-time 1000
   :threshhold 0))

(setf a5e
  (make-agent
   :name 'a5e
   :think-strategy 'deliberate-first
   :act-time 40
   :eval-strat 'seu-evaluate
   :wait-time 200
   :threshhold 0))

(setf a5s
  (make-agent
   :name 'a5s
   :think-strategy 'deliberate-first
   :act-time 40
   :eval-strat 'simple-evaluate
   :wait-time 200
   :threshhold 0))

(setf afe
  (make-agent
   :name 'afe
   :think-strategy 'deliberate-first
   :act-time 20
   :eval-strat 'seu-evaluate
   :wait-time 100
   :threshhold 0))

(setf afs
  (make-agent
   :name 'afs
   :think-strategy 'deliberate-first
   :act-time 20
   :eval-strat 'simple-evaluate
   :wait-time 100
   :threshhold 0))

(setf a20e
  (make-agent
   :name 'a20e
   :think-strategy 'deliberate-first
   :act-time 10
   :eval-strat 'seu-evaluate
   :wait-time 50
   :threshhold 0))

(setf a20s
  (make-agent
   :name 'a20s
   :think-strategy 'deliberate-first
   :act-time 10
   :eval-strat 'simple-evaluate
   :wait-time 50
   :threshhold 0))

(setf a0e
  (make-agent
   :name 'a0e
   :think-strategy 'deliberate-first
   :act-time 20000
   :eval-strat 'seu-evaluate
   :wait-time 100000
   :threshhold 0))

(setf a0s
  (make-agent
   :name 'a0s
   :think-strategy 'deliberate-first
   :act-time 20000
   :eval-strat 'simple-evaluate
   :wait-time 100000
   :threshhold 0))

(setf a1e
  (make-agent
   :name 'a1e
   :think-strategy 'deliberate-first
   :act-time 2000
   :eval-strat 'seu-evaluate
   :wait-time 10000
   :threshhold 0))

(setf a1s
  (make-agent
   :name 'a0s
   :think-strategy 'deliberate-first
   :act-time 2000
   :eval-strat 'simple-evaluate
   :wait-time 10000
   :threshhold 0))

;;; worlds are named as follows:
;  w
;  n (normal speed) / f (fast, 10x speec)
;  n (normal score range 25-75) / w (wide score range 1-100) / t (thin score
;                                                       range 45-55)
;  n (normal size range 1-4) / w (wide size range 1-7) / t (thin size 
;     range 2-2)

(setf wnnn
  (make-tw 
   :name 'wnnn
      :rows 20
      :cols 20
      :slice 1000
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 15000 :ms-disappear nil
  			   :num (make-subknob :start 2 :min 1 :max 4)
  			   :cells (make-subknob :min 1 :max 4)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 25 :max 75)
  			   :timeout (make-subknob :min 15000 :max 80000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 6 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 30 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 

(setf wnwn
  (make-tw 
   :name 'wnwn
      :rows 20
      :cols 20
      :slice 1000
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 15000 :ms-disappear nil
  			   :num (make-subknob :start 2 :min 1 :max 4)
  			   :cells (make-subknob :min 1 :max 4)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 15000 :max 80000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 6 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 30 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 

; 
; special set of parms to make dumb thresholds as good as possible.
; size-1 holes, pretty speedy appear/disappear
; this is 'e1a' slowed down 10x for sun-3

(setf w3w1 
   (make-tw 
    :name 'w3w1
    :rows 20
    :cols 20
    :slice 1000
    :is-automatic t
    :must-match-shapes nil
    :hole-knobs (make-knob :ms-appear 5000 :ms-disappear nil
			   :num (make-subknob :start 2 :min 1 :max 5)
			   :cells (make-subknob :min 1 :max 1)
			   :depth (make-subknob :min 1 :max 1)
			   :score (make-subknob :min 0 :max 100)
			   :timeout (make-subknob :min 2500 :max 20000)
			   :score-decay nil
			   :score-decay-is-relative t)
    :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
			       :num (make-subknob :start 6 :min 4 :max 9)
			       :cells (make-subknob :min 1 :max 10))
    :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
			   :num (make-subknob :start 30 :min 6 :max 30)
			   :cells (make-subknob :min 1 :max 1))
    :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
			    :num (make-subknob :start 1 :min 1 :max 1)
			    :cells (make-subknob :min 1 :max 1))
))


(setf woww    			; 'o' speed means 'n' but triple the hole
				; appearance rate and double the disapp. rate
				; while keeping act time constant.
				; Other changes from wnww: more tiles, 
				; fewer obstacles, more holes.
  (make-tw 
   :name 'woww
      :rows 20
      :cols 20
      :slice 1000
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 5000 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 7500 :max 40000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 

(setf w5ww
  (make-tw 
   :name 'w5ww
      :rows 20
      :cols 20
      :slice 200
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 1000 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 1500 :max 8000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 


(setf wgww    			; 'g' is to 'f' as 'o' is to 'n'
  (make-tw 
   :name 'wgww
      :rows 20
      :cols 20
      :slice 100
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 500 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 750 :max 4000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 

(setf w20ww
  (make-tw 
   :name 'w20ww
      :rows 20
      :cols 20
      :slice 50
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 250 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 375 :max 2000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 


(setf w0ww    			; '0' is 'o' but very very slow act/think
  (make-tw 
   :name 'wgww
      :rows 20
      :cols 20
      :slice 100000
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 500000 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 750000 :max 4000000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 


(setf w1ww    			; '0' is 'o' but very very slow act/think
  (make-tw 
   :name 'wgww
      :rows 20
      :cols 20
      :slice 10000
      :is-automatic t
      :must-match-shapes nil
      :hole-knobs (make-knob :ms-appear 50000 :ms-disappear nil
  			   :num (make-subknob :start 4 :min 2 :max 6)
  			   :cells (make-subknob :min 1 :max 7)
  			   :depth (make-subknob :min 1 :max 1)
  			   :score (make-subknob :min 1 :max 100)
  			   :timeout (make-subknob :min 75000 :max 400000))
      :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
  			       :num (make-subknob :start 3 :min 4 :max 9)
  			       :cells (make-subknob :min 1 :max 10))
      :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
  			   :num (make-subknob :start 50 :min 6 :max 30)
  			   :cells (make-subknob :min 1 :max 1))
      :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
  			    :num (make-subknob :start 1 :min 1 :max 1)
  			    :cells (make-subknob :min 1 :max 1))
)) 


