; curses interface for lisp

(def-foreign-function twinitdisp)
(def-foreign-function twclosedisp)
(def-foreign-function twdisplay
    (rows :signed-32bit) (cols :signed-32bit) (terrain :simple-string))
(def-foreign-function twclear)
(def-foreign-function (twgetch (:return-type :character)))

(load-foreign-files '("~ringuett/tile/twdisp.o")
		    '("-lcurses" "-ltermcap" "-lc"))

(defvar arr-string (with-static-area (make-string 4000)))

(defun tw-display-array (rows cols arr)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref arr-string (+ (* i cols) j))
		  (aref arr i j))))
    (twdisplay rows cols arr-string))
