;;;
;;; world.lisp
;;;

(in-package 'xtile)

(defun xtw-world-start ()
  ;(setf *keephistory* nil)		;These are all fossils
  ;(setf *historyfile* nil)
  (setf *exprfile* *exper-logfile*)
  (setf *game-length* *world-time-limit*)
  (setf *current-seed* *world-rand-seed*)
  (setf *seeds-left* *world-nseeds*)
  ;(if (or (not (boundp '*world*)) (null *world*))
  ;(setf *world* wnnn))		;just a dummy kind of thing, fossil
  (setf (tw-rand-seed *world*) *world-rand-seed*)
  (setf (tw-rows *world*) *world-board-size*)
  (setf (tw-cols *world*) *world-board-size*)
  (xtw-set-world-knobs)
  (setf *elapsed* 0)
  (setf *time-remaining* (- *game-length* *elapsed*))
  (tw-init *world*)
  (xtw-world-display *world*)
  (xtw-world-new-dialog)
  (keephist  "HOLES INITIALLY AROUND:"  'write-holes (tw-hole-list *world*))
  nil
  )

(defun xtw-set-world-knobs ()
  (setf (knob-ms-appear (tw-hole-knobs *world*)) 
	(round 15000 *world-speed*))
  (setf (subknob-min (knob-timeout (tw-hole-knobs *world*))) 
	(round 15000 *world-speed*))
  (setf (subknob-max (knob-timeout (tw-hole-knobs *world*))) 
	(round 80000 *world-speed*))
  (setf (subknob-min (knob-score (tw-hole-knobs *world*))) 
	*world-hole-score-min*)
  (setf (subknob-max (knob-score (tw-hole-knobs *world*))) 
	*world-hole-score-max*)
  (setf (subknob-min (knob-cells (tw-hole-knobs *world*))) 
	*world-hole-size-min*)
  (setf (subknob-max (knob-cells (tw-hole-knobs *world*))) 
	*world-hole-size-max*)
  )

;;; Here's a function we might use to create a whole new
;;; world structure, like the wnnn world from the old parms.lisp.
;;; Most of these fields would be overwritten anyway by
;;; xtw-world-start and xtw-set-world-knobs.

;(defun xtw-world-init ()
;  (setf *world*
;	(make-tw 
;	 :name 'default
;	 :rows 20
;	 :cols 20
;	 :slice 1000
;	 :is-automatic t
;	 :must-match-shapes nil
;	 :hole-knobs (make-knob :ms-appear 15000 :ms-disappear nil
;				:num (make-subknob :start 2 :min 1 :max 4)
;				:cells (make-subknob :min 1 :max 4)
;				:depth (make-subknob :min 1 :max 1)
;				:score (make-subknob :min 25 :max 75)
;				:timeout (make-subknob :min 15000 :max 80000))
;	 :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
;				    :num (make-subknob :start 6 :min 4 :max 9)
;				    :cells (make-subknob :min 1 :max 10))
;	 :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
;				:num (make-subknob :start 30 :min 6 :max 30)
;				:cells (make-subknob :min 1 :max 1))
;	 :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
;				 :num (make-subknob :start 1 :min 1 :max 1)
;				 :cells (make-subknob :min 1 :max 1))
;	 )))

;;; However, currently we never need more than one world
;;; structure in existance at any given time, so the above
;;; is commented out and we just create the structure at
;;; load-time right here.

(setf *world*
      (make-tw
       :name 'theworld
       :slice 1000
       :is-automatic t
       :must-match-shapes nil
       :hole-knobs (make-knob :ms-appear 15000 :ms-disappear nil
			      :num (make-subknob :start 2 :min 1 :max 4)
			      :cells (make-subknob :min 1 :max 4)
			      :depth (make-subknob :min 1 :max 1)
			      :score (make-subknob :min 25 :max 75)
			      :timeout (make-subknob :min 15000 :max 80000))
       :obstacle-knobs (make-knob :ms-appear nil :ms-disappear nil
				  :num (make-subknob :start 6 :min 4 :max 9)
				  :cells (make-subknob :min 1 :max 10))
       :tile-knobs (make-knob :ms-appear nil :ms-disappear nil
			      :num (make-subknob :start 30 :min 6 :max 30)
			      :cells (make-subknob :min 1 :max 1))
       :agent-knobs (make-knob :ms-appear nil :ms-disappear nil
			       :num (make-subknob :start 1 :min 1 :max 1)
			       :cells (make-subknob :min 1 :max 1))
       ))

