;;;
;;; world-dialog.lisp
;;;
;;; Dialog box stuff for the world module.
;;;

(in-package 'xtile)

(defvar *world-dialog-spec*)
(defvar *world-dialog*)
(defvar *wdlg-timefield*)
(defvar *wdlg-scorefield*)

(setf *world-dialog-spec*
      (make-dialog-spec 
       :name "World Parameters"
       :buttons nil
       :fields (list
		(make-field-spec
		 :label "World name:"
		 :getf #'(lambda () *world-name*)
		 :testf #'(lambda (x) (or x t))
		 :putf #'(lambda (x) (setf *world-name* x)))
		(make-field-spec 
		 :label "Speed:"
		 :getf #'(lambda () (format () "~s" *world-speed*))
		 :testf #'(lambda (x) (and (floatp (read-from-string x)) 
					   (< 0 (read-from-string x) 10)))
		 :putf #'(lambda (x) 
			   (setf *world-speed* (read-from-string x)) 
			   (xtw-set-world-knobs)))
		(make-field-spec 
		 :label "Score range:"
		 :getf #'(lambda () (format () "~s-~s" 
					    *world-hole-score-min*
					    *world-hole-score-max*))
		 :testf #'(lambda (x) (parse-range x))
		 :putf #'(lambda (x) 
			   (multiple-value-bind 
			    (min max) (parse-range x)
			    (when (and min max)
				  (setf *world-hole-score-min* min)
				  (setf *world-hole-score-max* max)
				  (xtw-set-world-knobs)))))
		(make-field-spec
		 :label "Size range:"
		 :getf #'(lambda ()(format nil "~s-~s"
					   *world-hole-size-min*
					   *world-hole-size-max*))
		 :testf #'(lambda (x) (parse-range x))
		 :putf #'(lambda (x) 
			   (multiple-value-bind 
			    (min max) (parse-range x)
			    (when (and min max)
				  (setf *world-hole-size-min* min)
				  (setf *world-hole-size-max* max)
				  (xtw-set-world-knobs)))))
		(make-field-spec 
		 :label "Game length:"
		 :getf #'(lambda () (format nil "~s" *game-length*))
		 :testf #'(lambda (x) (integerp (read-from-string x nil)))
		 :putf #'(lambda (x)
			   (setf *world-time-limit* 
				 (read-from-string x nil))
			   (setf *game-length* *world-time-limit*)
			   (setf *time-remaining* 
				 (- *game-length* *elapsed*))
			   (xtw-world-timedisp)))
		(setf *wdlg-timefield* 
		      (make-field-spec 
		       :label "Time remaining:"
		       :getf #'(lambda () 
				 (format nil "~s" *time-remaining*))
		       :testf #'(lambda (x) (integerp (read-from-string 
						       x nil)))
		       :putf #'(lambda (x)
				 (setf *time-remaining* (read-from-string 
							 x nil))
				 (setf *elapsed* (- *game-length* 
						    *time-remaining*)))))
		(setf *wdlg-scorefield* 
		      (make-field-spec
		       :label "Score:"
		       :getf #'(lambda () 
				 (format nil "~3D" (tw-score *world*)))
		       :testf #'(lambda (x) (or x t))
		       :putf #'(lambda (x) x)
		       ))
		(make-field-spec
		 :label "Current seed:"
		 :getf #'(lambda () (format nil "~s" *current-seed*))
		 :testf #'(lambda (x) (integerp (read-from-string x nil)))
		 :putf #'(lambda (x)
			   (setf *world-rand-seed* 
				 (setf *current-seed* 
				       (read-from-string x nil)))))
		(make-field-spec
		 :label "Seeds remaining:"
		 :getf #'(lambda () (format nil "~s" *seeds-left*))
		 :testf #'(lambda (x) (integerp (read-from-string x nil)))
		 :putf #'(lambda (x)
			   (setf *world-nseeds*
				 (setf *seeds-left* 
				       (read-from-string x nil)))))
		(make-field-spec
		 :label "Wait between seeds?"
		 :getf #'(lambda () 
			   (if *world-wait-between-seeds* "yes" "no"))
		 :testf #'(lambda (x) (or (equal x "yes") (equal x "no")))
		 :putf #'(lambda (x)
			   (setf *world-wait-between-seeds* 
				 (equal x "yes"))))
		(make-field-spec
		 :label "Wait after all seeds?"
		 :getf #'(lambda () 
			   (if *world-wait-after-all-seeds* "yes" "no"))
		 :testf #'(lambda (x) (or (equal x "yes") (equal x "no")))
		 :putf #'(lambda (x)
			   (setf *world-wait-after-all-seeds* 
				 (equal x "yes"))))
		)))

;;; update fields in dialog, or create a new one if necessary

(defun xtw-world-new-dialog ()
  (if (null *world-dialog*) 
      (setf *world-dialog* (create-new-dialog *world-dialog-spec*))
    (update-fields *world-dialog*)))

;; display remaining time in the proper field of the world-dialog

(defun xtw-world-timedisp ()
  (redisplay-field-from-spec *wdlg-timefield*))


;; ditto for score

(defun xtw-world-scoredisp ()
  (redisplay-field-from-spec *wdlg-scorefield*))
