;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;; default.exper.lisp
;;;;;
;;;;; The default experiment-definition file.
;;;;; When loaded, sets up things so that xtile will do one single, simple
;;;;; experiment when run.
;;;;;
;;;;; The format for experiment-definition files is motivated by a need
;;;;; for both flexibility and interactive changeability even after the
;;;;; series of experiments has started.
;;;;;
;;;;; Experiment-definition files will be evaluated when read in, so
;;;;; they can do anything.  But the primary thing they need to do is
;;;;; to set *experiment-list* to a list of individual experiments.
;;;;;
;;;;; Each individual experiment, for maximum flexibility, is a
;;;;; function, whose primary purpose is to set up experiment parameters.
;;;;; 
;;;;; The kinds of things that the functions need to do to set up
;;;;; the world or agent is determined only by the needs of the current
;;;;; world or agent modules.  If the modules provide functions to
;;;;; set up stuff easily, you may use those.
;;;;;
;;;;; One more thing that an experiment-definition file may want to
;;;;; do is set the value of *series-name* to something appropriate.
;;;;;

;;; The following is machine-generated experiment file code generated by
;;; the exper-save function in exper/exper-save.  Don't tamper with it
;;; unless you know what you're doing.  This file can safely be concat-
;;; enated together with other experiment files to produce a series of
;;; experiments.


(IN-PACKAGE 'XTILE::XTILE)
(IF (NOT (BOUNDP 'XTILE::*EXPERIMENT-LIST*))
    (SETF XTILE::*EXPERIMENT-LIST* NIL))
(SETF XTILE::*EXPERIMENT-LIST*
      (CONS
        '(PROGN (SETF XTILE::*SERIES-NAME* "default series")
          (SETF XTILE::*EXPER-NAME* "default experiment")
          (SETF XTILE::*EXPER-SAVE-FILE-NAME* "save.exper.lisp")
	  (setf xtile::*exper-keeplog* t)
          (SETF XTILE::*EXPER-LOGFILE* "default.exper.log")
          (SETF XTILE::*EXPER-KEEPHISTORY* NIL)
          (SETF XTILE::*EXPER-HISTORYFILE* "history")
          (SETF XTILE::*EXPER-SAVE-TIME* '(1990 9 14 12 39 57))
          (SETF XTILE::*AGENT-NAME* "Dr. Default")
          (SETF XTILE::*AGENT-SPEED* 1.0)
          (SETF XTILE::*AGENT-EVALFUNC* 'XTILE::SIMPLE-EVALUATE)
          (SETF XTILE::*AGENT-THRESHOLD* 50) NIL
          (SETF XTILE::*WORLD-NAME* "Defaultopolis")
          (SETF XTILE::*WORLD-SPEED* 1.0)
          (SETF XTILE::*WORLD-HOLE-SCORE-MIN* 25)
          (SETF XTILE::*WORLD-HOLE-SCORE-MAX* 75)
          (SETF XTILE::*WORLD-HOLE-SIZE-MIN* 1)
          (SETF XTILE::*WORLD-HOLE-SIZE-MAX* 4)
          (SETF XTILE::*WORLD-TIME-LIMIT* 80000)
          (SETF XTILE::*WORLD-RAND-SEED* 0) (SETF XTILE::*WORLD-NSEEDS* 100)
          (SETF XTILE::*WORLD-WAIT-BETWEEN-SEEDS* NIL)
          (SETF XTILE::*WORLD-WAIT-AFTER-ALL-SEEDS* T)
          (SETF XTILE::*WORLD-BOARD-SIZE* 20))
        XTILE::*EXPERIMENT-LIST*))
