;;;
;;; logging.lisp
;;;
;;; Stuff for experiment logging.
;;;

(in-package 'xtile)

(defvar *exper-log-stream*)		;the stream
(defvar *exper-log-filename*)		;the full filename
(defvar *total-score*)
(defvar *num-games*)

(defun close-log-if-open ()
  (when *exper-log-stream* 
	(close *exper-log-stream*)
	(setf *exper-log-stream* nil)))

(defun with-open-log (form)
  (when *exper-keeplog*
	(setf *exper-log-filename*
	      (defsystem::append-directories
		*experiment-dir-name*
		*exper-logfile*))
	(with-open-file (*exper-log-stream* *exper-log-filename*
					    :direction :output
					    :if-exists :append
					    :if-does-not-exist :create)
			(eval form))))

(defun open-log ()
  (close-log-if-open)
  (setf *exper-log-stream* (open *exper-log-filename* 
				 :direction :output
				 :if-exists :rename))
  (setf *total-score* 0)
  (setf *num-games* 0)
  )

(defun log-init ()
  (setf *total-score* 0)
  (setf *num-games* 0))

(defun log-settings ()
  (with-open-log
   '(record-settings *world-rand-seed*)))

(defun log-score ()
  (with-open-log
   '(progn
      (record-score (tw-score *world*))
      (setf *total-score* (+ *total-score* (tw-score *world*)))
      (setf *num-games* (+ *num-games* 1))
      )
   )
  )

(defun log-average ()
  (with-open-log
   '(unless (zerop *num-games*)
	    (record-average (round (/ *total-score* *num-games*)))
	    (format *exper-log-stream*
		    "Logged at time ~s.~%"
		    (exper-current-time)))))

;;;;; These are from the old exper.l, 
;;;;; with a0 and w0 and *expr* changed to *agent* and *world*
;;;;; and *exper-log-stream*.

(defun record-settings (seed)
  (write (agent-name *agent*) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write (tw-name *world*) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)(write-char #\Newline *exper-log-stream*)
  (write "Seed:"  :stream *exper-log-stream*)
  (write seed :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "===========================" :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Agent Settings:" :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Eval Strategy:" :stream *exper-log-stream*)
  (write (agent-eval-strat *agent*) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Act Time:" :stream *exper-log-stream*)
  (write (agent-act-time *agent*) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Threshold:" :stream *exper-log-stream*)
  (write (agent-threshhold *agent*) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "===========================" :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "World Settings:"  :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Hole Appearance Rate:" :stream *exper-log-stream*)
  (write (knob-ms-appear (tw-hole-knobs *world*)) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Hole Disappear Rate:" :stream *exper-log-stream*)
  (write (knob-ms-disappear (tw-hole-knobs *world*)) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Hole Size Range:" :stream *exper-log-stream*)
  (write (subknob-min (knob-cells (tw-hole-knobs *world*))) :stream *exper-log-stream*)
  (write "to " :stream *exper-log-stream*)
  (write (subknob-max (knob-num (tw-hole-knobs *world*))) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Hole Score Range:" :stream *exper-log-stream*)
  (write (subknob-min (knob-score (tw-hole-knobs *world*))) :stream *exper-log-stream*)
  (write "to " :stream *exper-log-stream*)
  (write (subknob-max (knob-score (tw-hole-knobs *world*))) :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
;  add the rest later
  (write "===========================" :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
)

(defun record-score (score)
   (write score :stream *exper-log-stream*)
   (write-char #\Newline *exper-log-stream*))

(defun record-average (ave)
  (write "===========================" :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
  (write "Average:" :stream *exper-log-stream*)
  (write ave :stream *exper-log-stream*)
  (write-char #\Newline *exper-log-stream*)
)
	  

