;;;
;;; exper-dialog.lisp
;;;
;;; Dialog box stuff for the experiment module.
;;;

(in-package 'xtile)

(setf *exper-save-time* nil)

(setf *exper-dialog-spec*
      (make-dialog-spec :name "Experiment Control"
			:fields (list
				 (make-field-spec
				  :label "Save time:"
				  :getf #'(lambda () (prin1-to-string *exper-save-time*))
				  :testf #'(lambda (x) (or x t))
				  :putf #'(lambda (x) x)
				  )
				 (make-field-spec
				  :label "Load:"
				  :getf #'(lambda () *loaded-as*)
				  :testf #'(lambda (x) (or x t))
				  :putf #'(lambda (x) (setf *loaded-as* x))
				  )
				 (make-field-spec
				  :label "Save:"
				  :getf #'(lambda () *exper-save-file-name*)
				  :testf #'(lambda (x) (not (eql x "")))
				  :putf #'(lambda (x) (setf
						       *exper-save-file-name*
						       x)))
				 (make-field-spec
				  :label "Keep history?"
				  :getf #'(lambda () 
					    (if *exper-keephistory* 
						"yes" "no"))
				  :testf #'(lambda (x)
					     (or (equal x "yes")
						 (equal x "no")))
				  :putf #'(lambda (x)
					    (setf *exper-keephistory*
						  (equal x "yes"))))
				 (make-field-spec
				  :label "History:"
				  :getf #'(lambda () *exper-historyfile*)
				  :testf #'(lambda (x) (not (equal x "")))
				  :putf #'(lambda (x) 
					    (setf *exper-historyfile* x)))
				 (make-field-spec
				  :label "Keep log?"
				  :getf #'(lambda () 
					    (if *exper-keeplog* 
						"yes" "no"))
				  :testf #'(lambda (x)
					     (or (equal x "yes")
						 (equal x "no")))
				  :putf #'(lambda (x)
					    (setf *exper-keeplog*
						  (equal x "yes"))))
				 (make-field-spec
				  :label "Log:"
				  :getf #'(lambda () *exper-logfile*)
				  :testf #'(lambda (x) (not (equal x "")))
				  :putf #'(lambda (x) 
					    (setf *exper-logfile* x)))
				 (make-field-spec
				  :label "Series:"
				  :getf #'(lambda () *series-name*)
				  :testf #'(lambda (x) (not (eql x "")))
				  :putf #'(lambda (x) (setf *series-name* x))
				  )
				 (make-field-spec
				  :label "Experiment:"
				  :getf #'(lambda () *exper-name*)
				  :testf #'(lambda (x) (not (eql x "")))
				  :putf #'(lambda (x) (setf *exper-name* x))
				  ))

			:buttons (list
				  (make-button-spec :label "Start or Continue Game"
						    :actionf 'xtw-start)
				  (make-button-spec :label "Stop (Pause) Game"
						    :actionf 'xtw-stop)
				  (make-button-spec :label "Reset to Beginning of Game"
						    :actionf 'xtw-reset)
				  (make-button-spec :label "Save Current Settings"
						    :actionf 'xtw-save)
				  (make-button-spec :label "Reload Experiment File"
						    :actionf 'xtw-reload)
				  (make-button-spec :label "Quit Tileworld System"
						    :actionf 'xtw-quit)
				  )
			)
      )

(defun xtw-start ()
  (format t "~&;;; [Game running.]~%")
  (setf *busy* t)
  )

(defun xtw-stop ()
  (format t "~&;;; [Game pausing.]~%")
  (setf *busy* nil)
  )

(defun xtw-reset ()
  (format t "~&;;; [Game resetting.]~%")
  (xtw-start-experiment)
  )

(defun xtw-save ()
  (format t "~&;;; [Saving game.]~%")
  (exper-save)
  )

(defun xtw-reload ()
  (format t "~&;;; [Reloading ~s.]~%" *loaded-as*)
  (load-experiment-file *loaded-as*)
  (post-load)
  (start-game)
  )

(defun xtw-quit ()
  (format t "~&;;; [Quitting.]~%")
  (xtw-end-match)
  )

(defun xtw-exper-update-dialog ()
  (if (null *exper-dialog*)
      (setf *exper-dialog* (create-new-dialog *exper-dialog-spec*))
    (update-fields *exper-dialog*)
    ))
