
(in-package 'xtile)

(def-foreign-function (c-moveplan (:return-type (:pointer :character))
				  (:name "_moveplan")
				  (:language :c))
  (rows :signed-32bit) (cols :signed-32bit)
  (grid (:pointer :character)) (occupied (:pointer :character))
  (row :signed-32bit) (col :signed-32bit)
  )

(defun moveplan (rows cols grid occ row col)
  (check-type grid string)
  (check-type occ string)
  (let ((f-grid (malloc-foreign-string grid))
	(f-occ (malloc-foreign-string occ))
	res)
    (prog1 (foreign-string-value (setf res (c-moveplan 
					    rows cols f-grid f-occ row
					    col)))
      (free-foreign-pointer f-grid)
      (free-foreign-pointer f-occ)
      (free-foreign-pointer res))))

(def-foreign-function (c-pushplan (:return-type (:pointer :character))
				(:name "_pushplan")
				(:language :c))
  (rows :signed-32bit) (cols :signed-32bit)
  (grid (:pointer :character)) (occupied (:pointer :character))
  (row :signed-32bit) (col :signed-32bit) (orientation :signed-32bit)
  )

(defun pushplan (rows cols grid occ row col ori)
  (check-type grid string)
  (check-type occ string)
  (let ((f-grid (malloc-foreign-string grid))
	(f-occ (malloc-foreign-string occ))
	res)
    (prog1 (foreign-string-value (setf res (c-pushplan 
					    rows cols f-grid f-occ row
					    col ori)))
      (free-foreign-pointer f-grid)
      (free-foreign-pointer f-occ)
      (free-foreign-pointer res))))


(load-foreign-files '("~tile/xtile/agent/twmove.o" 
		      "~tile/xtile/agent/twpush.o" 
		      "~tile/xtile/agent/bfs.o" 
		      "~tile/xtile/agent/heap.o"
		      )
		    '("-lc")
		    )

(defun malloc-foreign-string (str)
  (check-type str string)
  (let ((f-str (malloc-foreign-pointer
		:type
		`(:pointer (:array :character (,(1+ (length str))))))))
    (setf (foreign-string-value f-str)
	  str)
    (setf (foreign-pointer-type f-str)
	  '(:pointer :character))
    f-str))
