;;;
;;; agent.lisp
;;;

(in-package 'xtile)

(defun xtw-agent-start ()
  (xtw-set-agent-parms)
  (agent-init *agent* *world*)
  (keephist "INITIAL MENTAL STATE:" 'write-mind *agent*)
  )

(defun xtw-set-agent-parms ()
  (setf (agent-act-time *agent*) (round 200 *agent-speed*))
  (setf (agent-wait-time *agent*) (round 1000 *agent-speed*))
  (setf (agent-eval-strat  *agent*) *agent-evalfunc*)
  (setf (agent-threshhold *agent*) *agent-threshold*)
  )

;; Seemingly we will only ever need one agent structure, so just create in at load time.
;; Most of the fields will be overwritten when parameters are loaded, anyway.

(setf *agent*
  (make-agent
   :name 'default
   :think-strategy 'deliberate-first
   :act-time 200
   :eval-strat 'seu-evaluate
   :wait-time 1000
   :threshhold 10))
