;;; Common lisp code to set up for tileworld development and usage.
;;; May be inserted into a user's lisp-init.lisp file.

;;;  by Michael Frank

(in-package 'user)

;;;
;;; The following loads Mark Kantrowitz's Defsystem facility,
;;; which I use to define the xtile system.
;;;

(load "~tile/cl-util/defsystem")

;;;
;;; This sets the central registry directory that Defsystem will
;;; use to look for tileworld and related systems.
;;;

(setq defsystem::*central-registry*  "~tile/reg/")

;;;
;;; We load the system definition for xtile so that we can use
;;; Defsystem's operate-on-system function on it.  Require would
;;; do this automatically, though.
;;;

(load (defsystem::append-directories 
	defsystem::*central-registry* 
	"xtile.system"))

;;;
;;; This function loads the entire xtile system and
;;; makes it available to the user.
;;;

(defun load-tw ()
  (require 'xtile)			;Load xtile if it isn't already.
  (use-package 'xtile))			;Make (run) available to the user.

(defun xtile () (load-tw))  ;for backwards-compatibility

;;;
;;; This function compiles any source files that have changed since
;;; the last time they were compiled, but does not recompile their
;;; dependents.  (Since I don't use macros, there's no need.)
;;; It loads in the compiled files after compiling them.
;;;

(defun c ()
  (operate-on-system 'xtile 'compile 
		     :force :new-source 
		     ))

;;;
;;; This function loads xtile verbosely, and will load sources that
;;; don't have binaries without bothering the user.
;;;

(defun l ()
  (operate-on-system 'xtile 'load
		     :verbose t
		     :load-source-if-no-binary t
		     :bother-user-if-no-binary nil)
  (use-package 'xtile))

;;;
;;; So, shall we go ahead and do it?  Load tileworld!
;;;

(format t ";;; Loading system ~cxtile~c~%" #\" #\")
(load-tw)
