/**************************************************************************/
/* compute.h                                                    /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/



#ifndef _compute_h
#define _compute_h


#ifndef COMPUTE_EXTERN
#	define COMPUTE_EXTERN extern
#endif



#include "config.h"

#include "matrix.h"



void init_transformations(REAL scale_fac, REAL focus,
			  REAL theta, REAL alfa, REAL distance);
void init_homogen(void);
void re_compute_z_points(void);
void re_compute_points(void);
void update_segments(int *k);
void compute_wire_frame(void);
void dump_wire_frame(void);


COMPUTE_EXTERN homo PV;

#endif
