/**************************************************************************/
/* global_simmel.h                                              /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _global_simmel_h
#define _global_simmel_h

#ifndef GLOBAL_EXTERN
#define GLOBAL_EXTERN extern
#endif


#include "config.h"

#include "def.h"
#include "vector.h"


/*
 * Size of general purpose buffers which cannot be
 * dynamically allocated.
 */
#define BUF_SIZE	8192


/*
 * The homogenous matrices.  Note that joint_homo[NR_LINKS]
 * contains the homogenous matrix for the last joint, i.e.,
 * the last coordinate system.
 */
GLOBAL_EXTERN homo joint_homo[NR_LINKS+1];


/*
 * Global variable: the current position, speed, and acceleration
 * of each joint, in joint domain.
 */
GLOBAL_EXTERN joint_values q, dq, ddq;

/*
 * Global variable: the current position, speed, and acceleration
 * of each link in Cartesian domain; the radial velocity omega
 * as well as its derivative.
 */
GLOBAL_EXTERN vector p[NR_LINKS+1], v[NR_LINKS+1], a[NR_LINKS+1];
GLOBAL_EXTERN vector omega[NR_LINKS+1], d_omega[NR_LINKS+1];
/*
 * Global variable: the position, velocity, and acceleration
 * of the object in world domain as well as relative to
 * the hand.
 */
GLOBAL_EXTERN vector object_position,
  object_velocity, object_acceleration;
GLOBAL_EXTERN vector hand_object_position,
  hand_object_velocity, hand_object_acceleration;
GLOBAL_EXTERN vector area;
GLOBAL_EXTERN joint_values q, dq, ddq;
GLOBAL_EXTERN REAL E, focus;


/*
 * The sequence number of this connected simulator.  If #1 then
 * it's the main one.
 */
GLOBAL_EXTERN int sequence;

#undef GLOBAL_EXTERN
#endif
