/**************************************************************************/
/* communication.c                                              /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#include "config.h"

#include <stdio.h>
#include <signal.h>
#include <stdlib.h>


#include <errno.h>

#define COMMUNICATION_EXTERN


#include "communication.h"
#include "datastruct.h"
#include "xgraphics.h"


/* for sockets */
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/time.h>


#include <X11/Xlib.h>
#include <X11/Xutil.h>



void read_next_message(void)
{
  int length;
  char *buffer, type;
  extern int errno;
  unsigned short nr;

  nr = 0;
  while (1)
  {
	fd_set fdset;
	int from_homo=0, from_event=0;

	/*
	 * Check two sockets: the incoming homogenous matrix socket,
	 * and the socket containing XEvents.
	 */
	FD_ZERO(&fdset);
	FD_SET(ConnectionNumber(display), &fdset);
	if (select(GETDTABLESIZE, &fdset, (fd_set *) NULL, (fd_set *) NULL,
						(struct timeval *) NULL) == -1)
	{
		perror("graphics/read_next_message: select()");
		abort();
	}

	if (FD_ISSET(ConnectionNumber(display), &fdset))
	{
		/*
		 * We got an event.  Immediately jump to the event handling
		 * routine, and jump over the rest of the loop.
		 */
		handle_next_window_event();
		continue;
	}
	else
	{
		/*
		 * This can never occur.
		 */
		fprintf(stderr, "graphics/read_next_message(): select error\n");
		abort();
	}
	if (buffer != NULL)
		free(buffer);
  }
}
