/**************************************************************************/
/* kinematic.h                                                  /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _kinematic_h
#define _kinematic_h

#include "config.h"

#include "global_simmel.h"



unsigned short check_limits(joint_values, REAL *, REAL *);
int check_end_effector(REAL x, REAL y, REAL z);
void forward_kinematics(joint_values target_position);
void display_robot(void);
void init_forwardkinematics(char *robotdefinition);
void couple_joints(joint_values, joint_values, joint_values,
			joint_values, joint_values, joint_values);
void decouple_joints(joint_values, joint_values, joint_values,
			joint_values, joint_values, joint_values);
unsigned short move(joint_values q_1, joint_values dq_1,
			joint_values ddq_1);
void newton_euler(joint_values dq, joint_values ddq);
void relative_object_motion(void);
int ciszero(REAL x);
int cispos(REAL x);
void camera(void);


#endif
