/**************************************************************************/
/* inverse.h                                                    /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: A. Jansen                                         _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         ajansen@fwi.uva.nl                               | | \/\/ | |  */
/*                                                          | \______/ |  */
/*                                                           \________/   */
/*                                                                        */
/*                                                              /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _inverse_h
#define _inverse_h

#include "config.h"

#include "matrix.h"
#include "vector.h"

REAL my_atan2(REAL y, REAL x);
void calc_p_vector(REAL *p_6, REAL *a, REAL *p);
REAL joint_1_solution(short arm, REAL *p);
REAL joint_2_solution(short arm, short elbow, REAL theta_1, REAL *p);
REAL joint_1_CRAIG_solution(REAL *p);
REAL joint_3_CRAIG_solution(REAL theta_1, REAL *p, REAL *p_2,short *possible);
REAL joint_2_CRAIG_solution(REAL theta_3, REAL *p_2);
REAL joint_5_CRAIG_solution(REAL theta_2, REAL theta_3);
int inverse_kinematics_OSCAR(vector a, vector p_6, joint_values thetas);
void do_inverse(REAL x, REAL y, REAL z);
#endif
