/**************************************************************************/
/* command.h                                                    /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _command_h
#define _command_h

#ifndef COMMAND_EXTERN
#	define COMMAND_EXTERN extern
#	define COMMAND_EXTERN_INCLUSION
#else
#	undef COMMAND_EXTERN_INCLUSION
#endif


#define C_QUIT			0000001
#define T_QUIT			"Quit"
#define D_QUIT 			\
"Quit the program."

#define C_RESET			0000002
#define T_RESET			"reset"
#define D_RESET			\
"Reset the robot, i.e., move it to its `home' position."

#define C_HELP1			0000003
#define C_HELP2			0000004
#define T_HELP1			"help"
#define T_HELP2			"?"
#define	D_HELP			\
"Give a list of commands."

#define C_DESCRIBE		0000005
#define T_DESCRIBE		"describe"
#define D_DESCRIBE		\
"Describe a specific command.  Usage: `describe <command>' where\n\
<command> is one of the commands given with `help'."

#define C_VERSION		0000006
#define T_VERSION		"version"
#define D_VERSION		\
"Give version number."

#define C_JOINTS		0000100
#define T_JOINTS		"joints"
#define D_JOINTS		\
"Request the current joint values from the robot\n\
or robot simulator."

#define C_CAMERA		0000200
#define T_CAMERA		"camera"
#define D_CAMERA		\
"Request the current visual status from the vision\n\
hardware or robot simulator."

#define C_FIX_TARGET		0000300
#define T_FIX_TARGET		"fix-target"
#define D_FIX_TARGET		\
"For simulated robot only: send the positions of the\n\
target object to the robot simulator.  With the real robot,\n\
this is replaced by physically moving the object."

#define C_MOVE_ABSOLUTE	        0000400
#define T_MOVE_ABSOLUTE		"move-absolute"
#define D_MOVE_ABSOLUTE		\
"Move the robot by specifying absolute joint values."

#define C_MOVE_RELATIVE	        0000500
#define T_MOVE_RELATIVE		"move-relative"
#define D_MOVE_RELATIVE		\
"Move the robot by specifying relative joint values."

#define C_INVERSE_KINEMATICS	0000600
#define T_INVERSE_KINEMATICS	"inverse-kinematics"
#define D_INVERSE_KINEMATICS	\
"Execute inverse kinematics on a specified (x, y, z)\n\
position expressed relative to the base of the robot."

#define C_JUST_GET_IT           0000700
#define T_JUST_GET_IT           "just-get-it"
#define D_JUST_GET_IT           \
"Get visual object position, use forward kinematics\n\
to get hand position, and apply inverse kinematics\n\
to grasp the object.  I.e., just get it.\n"




COMMAND_EXTERN struct {
	int code;
	char *text;
	char *description;
} command[]
#	ifndef COMMAND_EXTERN_INCLUSION
= {
	{C_QUIT, T_QUIT, D_QUIT},
	{C_RESET, T_RESET, D_RESET},
	{C_HELP1, T_HELP1, D_HELP},
	{C_HELP2, T_HELP2, D_HELP},
	{C_DESCRIBE, T_DESCRIBE, D_DESCRIBE},
	{C_VERSION, T_VERSION, D_VERSION},
	{C_JOINTS, T_JOINTS, D_JOINTS},
	{C_CAMERA, T_CAMERA, D_CAMERA},
	{C_FIX_TARGET, T_FIX_TARGET, D_FIX_TARGET},
	{C_MOVE_ABSOLUTE, T_MOVE_ABSOLUTE, D_MOVE_ABSOLUTE},
	{C_MOVE_RELATIVE, T_MOVE_RELATIVE, D_MOVE_RELATIVE},
	{C_INVERSE_KINEMATICS, T_INVERSE_KINEMATICS, D_INVERSE_KINEMATICS},
	{C_JUST_GET_IT, T_JUST_GET_IT, D_JUST_GET_IT},
	{0, "", ""}
}
#	endif
;



char get_next_word(char **p_input_buffer);
void check_command_integrity(void);
long int parse_command(char **s);
void help(void);
void describe(void);



#endif
