/**************************************************************************/
/* communication.h                                              /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _communication_h
#define _communication_h

#include "config.h"

#include "global_simmel.h"

#ifndef COMMUNICATION_EXTERN
#	define COMMUNICATION_EXTERN extern
#endif



/*
 * The incoming lines from the controller are merged into
 * one data stream in the function receive_next_command().
 * In order to return to main() where the data came from,
 * either of these flags is returned.
 */
#define EMPTY_SOCKET	0
#define ROBOT		1
#define CAMERA		2
#define BEMMEL		3





COMMUNICATION_EXTERN int robot_connected, robot_socket;
COMMUNICATION_EXTERN int camera_connected, camera_socket;
COMMUNICATION_EXTERN int *bemmel_connected, *bemmel_socket, bemmels_connected;

void open_robot_communication(char *soocket_file_name);
void open_camera_communication(char *socket_file_name);
void open_bemmel_communication(char *basic_name, int bemmels_connected);
void accept_halt(void);
void ok_exit(void);
void panic_exit(void);
void close_down(char m_robot, char m_camera, char m_bemmel);
int select_receive_next_command(char *type, char **buffer,
					unsigned short *length, int pend);
int receive_next_command(char *type, char **buffer, unsigned short *length);
char check_bemmel_channels_for_data(void);
void send_homo(unsigned short nr, homo h);
void send_camera(char type, vector view_1, vector view_2);
void send_end_effector(vector effector);
void send_position_and_derivatives(vector x, vector dx, vector ddx);
void decode_camera(char *buffer, int length, vector object_position);
unsigned short decode_joints(char *buffer, int length, joint_values q,
			joint_values dq, joint_values ddq);
void send_joints(joint_values q, joint_values dq, joint_values ddq);
void setup_server_communication(char *socket_file,
			int *control_socket, int *data_socket);
void setup_client_communication(char *socket_file, char *host,
			int *socket_channel);
void send_data(int socket_channel, char code, unsigned short length, char *data);
int receive_using_select(int sock, char *buffer, int length);
int receive(int sock, char *buf, int length);
int receive_data(int socket_channel, char **buffer, char *type);


#endif
