/**************************************************************************/
/* global.h                                                     /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _global_h
#define _global_h

#include "config.h"

/*
 * The ordinary macro square, in which the argument gets
 * evaluated twice.
 */
#define Msqr(x)		((x)*(x))

/*
 * `Sophisticated' sqr macros in which the argument is
 * guaranteed to be evaluated only once.
 */
static REAL			R_tmp;
static double			d_tmp;
static float			f_tmp;
static int			i_tmp;
static short int		si_tmp;
static long int			li_tmp;
static unsigned int		ui_tmp;
static unsigned short int	usi_tmp;
static unsigned long int	uli_tmp;
#define R_sqr(x)	(R_tmp = (x), R_tmp * R_tmp)
#define d_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define f_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define i_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define si_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define li_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define ui_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define usi_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)
#define uli_sqr(x)	(d_tmp = (x), d_tmp * d_tmp)

#endif
