/**************************************************************************/
/* config.h                                                     /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _config_h
#define _config_h


#include "version.h"



/*
 * Define here what kind of reals you like: float or double.
 */
#define REAL		double



/*
 * Here define your machine.  Better choose one out of these!
 */

/* * Sun running SunOS.  */
#define SUN	1

/*
 * Silicon graphics.
 */
#define SGI	0

/*
 * PC running Linux.
 */
#define LINUX	0

/*
 * HP9000 S700.
 */
#define HP700	0



/*
 * Define HAVE_SIGNBIT if you have the signbit() and iszero() functions.
 * Otherwise, they will be replaced by l_signbit() and l_iszero()
 * which are defined in matrix/src/ieee.c.
 * If your machine does not have IEEE routines or is missing the include
 * file <fp_class.h>, define HAVE_SIGNBIT=0 and HAVE_IEEE_INCLUDES=0.
 *
 * If you do not have the getdtablesize() function, set HAVE_GETDTABLESIZE=0.
 */
#if SUN
#	define HAVE_SIGNBIT		1
#	define HAVE_IEEE_INCLUDES	1
#	define HAVE_GETDTABLESIZE	1
#elif SGI
#	define HAVE_SIGNBIT		0
#	define HAVE_IEEE_INCLUDES	1
#	define HAVE_GETDTABLESIZE	1
#elif LINUX
#	define HAVE_SIGNBIT		0
#	define HAVE_IEEE_INCLUDES	0
#	define HAVE_GETDTABLESIZE	1
#elif HP700
#	define HAVE_SIGNBIT		0
#	define HAVE_IEEE_INCLUDES	0
#	define HAVE_GETDTABLESIZE	0

#	define EWOULDBLOCK		246	/* Operation would block */
#endif




/*
 * If your C library does not have the function
 * getdtablesize(), set HAVE_GETDTABLESIZE to 0.
 */
#if HAVE_GETDTABLESIZE
#	define GETDTABLESIZE getdtablesize()
#else
#	define GETDTABLESIZE 256
#endif



#endif
