/**************************************************************************/
/* vector.h                                                     /\/\      */
/* Version 2.2.1 --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _vector_h
#define _vector_h


#include "matrix.h"


#define NR_LINKS	6

/*
 * Joint values are coded in degrees.  See DHfile for definition
 * of the robot.  Note that only positions 1...NR_LINKS of a
 * joint value array are relevant; position 0 is unused.
 */
typedef REAL joint_values[NR_LINKS+1];
#define NULL_MOVE	(REAL *) NULL


/*
 * The position of a target or the view of a camera are kept
 * in a four-dimensional vector (see matrix.h for definition
 * of HOMO_DEG).  Coding is as follows:
 *      vector[0] = x,
 *      vector[1] = y,
 *      vector[2] = z,
 *      vector[3] = w.
 */
typedef REAL vector[HOMO_DEG];



void copy_joints(joint_values destination, joint_values source);
void init_joints(joint_values destination);
void add_joints(joint_values destination, joint_values source1,
                joint_values source2);
void sub_joints(joint_values destination, joint_values source1,
                joint_values source2);
REAL vector_length(vector image);
void copy_vector(vector destination, vector source);
void sub_vector(vector destination, vector source1,  vector source2);
void add_vector(vector destination, vector source1, vector source2);
void init_vector(vector v);
void homo_vec_mul(vector result, homo H, vector vec);
void cross_product(vector result, vector source1, vector source2);


#endif
