/**************************************************************************/
/* moving.h                                                     /\/\      */
/* Version 2.2.1 --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _moving_h
#define _moving_h



/*
 * High joint velocity and acceleration.
 */
#define FAST_DQ		20.0
#define FAST_DDQ	20.0

/*
 * Standard joint velocity and acceleration.
 */
#define SLOW_DQ		3.0
#define SLOW_DDQ	1.0



void reset_robot(void);
unsigned short move_robot(joint_values delta_q, joint_values absolute_q,
			joint_values dq, joint_values ddq, REAL v, REAL a);
void fix_target(void);
void user_move_robot(void);
REAL deg2rad(REAL angle);
REAL rad2deg(REAL angle);

#endif
