/**************************************************************************/
/* main.c                                                       /\/\      */
/* Version x.x.x --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#include <stdio.h>
#include <signal.h>

#define GLOBAL_EXTERN
#include "global_communication.h"

#include "main.h"
#include "matrix.h"
#include "vector.h"

#include "setup.h"

void leave(void)
{
  close_down(STOP, STOP);
}




void main(int argc, char *argv[])
{
  int i;
  extern int robots, simulators;

  if (argc != 2)
  {
	fprintf(stderr,"Usage:  %s <r|s>\n",argv[0]);
	exit(1);
  }

  /*
   * Check how many robots and simulators must be connected.
   */
  for (i=0; i<strlen(argv[1]); i++)
	if (argv[1][i] == 'r')
		robots++;
	else if (argv[1][i] == 's')
		simulators++;
	else
	{
		fprintf(stderr, "illegal argument %c\n", argv[1][i]);
		exit(1);
	}

  if (robots + simulators == 0)
  {
	fprintf(stderr, "No robots connected---ready\n");
	exit(0);
  }



  signal(SIGQUIT, leave);
  signal(SIGINT, leave);

  on_robot();
  on_camera();
  loop();
  close_down(STOP, STOP);
}




void loop(void)
{
  vector cam_1_eef, cam_1_obj, cam_2_eef, cam_2_obj, hand_cam, area;
  vector object_pos;
  
  printf("Everybody seems to be listening, time to start.\n");
  printf("Please enter commands\n");

  /*
   * A nasty situation results when the robot simulator
   * has no clue as to how large the object supposedly
   * is.  So, before we generate any robot action, tell it.
   */
  E = 100.0; focus = 1.0;
  object_pos[0] = object_pos[1] = object_pos[2] = 0.0; object_pos[3] = 1.0;
  send_object_position(object_pos);

  reset_robot();

  while (1)
  {

        switch (get_next_command())
	{
	case 'a':
		{
			joint_values q, dq, ddq;
			int status;

			if (NR_LINKS != 6)
			{
				fprintf(stderr, "Only for 6DoF robot\n");
				return;
			}
			status = get_joint_values(0, 0, q, dq, ddq);
			if (status > 0)
				printf("still moving;\n");
			printf("  q = [%.2f %.2f %.2f %.2f %.2f %.2f]\n",
				q[1], q[2], q[3], q[4], q[5], q[6]);
			printf(" dq = [%.2f %.2f %.2f %.2f %.2f %.2f]\n",
				dq[1], dq[2], dq[3], dq[4], dq[5], dq[6]);
			printf("ddq = [%.2f %.2f %.2f %.2f %.2f %.2f]\n",
				ddq[1], ddq[2], ddq[3], ddq[4], ddq[5], ddq[6]);
		}
		break;

	case 'c':
		if (get_camera(0, CAMERA_1, cam_1_eef, cam_1_obj))
			printf("error camera 1\n");
		else
			printf("cam1: [%.2f %.2f %.2f] [%.2f %.2f %2f]\n",
				cam_1_eef[0], cam_1_eef[1], cam_1_eef[2],
				cam_1_obj[0], cam_1_obj[1], cam_1_obj[2]);
				
		if (get_camera(0, CAMERA_2, cam_2_eef, cam_2_obj))
			printf("error camera 2\n");
		else
			printf("cam2: [%.2f %.2f %.2f] [%.2f %.2f %2f]\n",
				cam_2_eef[0], cam_2_eef[1], cam_2_eef[2],
				cam_2_obj[0], cam_2_obj[1], cam_2_obj[2]);
				
		if (get_camera(0, HAND_CAMERA, hand_cam, area))
			printf("error hand camera\n");
		else
			printf("handcam: [%.2f %.2f %.2f] [%.2f %.2f %2f]\n",
				hand_cam[0], hand_cam[1], hand_cam[2],
				area[0], area[1], area[2]);
		break;

	case 'R':
		reset_robot();
		break;

	case 'm':
		user_move_robot();
		break;

	case 'f':
		fix_target();
		break;

	case 'k':
		init_kinematics("DHfile");
		inverse_kinematics();
		break;

  	case 'q':
		return;

  	default:
		printf("\nOptions:\n");
		printf("	a	ask for joint values\n");
		printf("        c       camera\n");
		printf("	m	move robot to specified position\n");
		printf("        R       reset robot\n");
		printf("	k	kinematics\n");
		printf("	f	fix target (simulator)\n");
		printf("        q       quit\n");
		break;
	}
  }
}



char get_next_command(void)
{
  int c;

  while (isspace(c = getchar()))
	if (c == EOF)
		close_down(STOP, STOP);

  return (char) c;
}
