/**************************************************************************/
/* communication.h                                              /\/\      */
/* Version 2.2.1 --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#ifndef _communication_h
#define _communication_h


#ifndef COMMUNICATION_EXTERN
#	define COMMUNICATION_EXTERN extern
#endif

#include "matrix.h"
#include "vector.h"


/*
 * Recommended size for I/O buffers.
 */
#define BUF_SIZE	8192


/*
 * To what are we connected?  For each socket,
 * the array type_of_connected[] (below) has
 * a value indicating whether the connected
 * party is a robot or a simulator.
 */
#define TYPE_ROBOT	0
#define TYPE_SIMULATOR	1



/*
 * I'd rather not use int, but sockets in UNIX are generally
 * ints; therefore, so are these.
 */
COMMUNICATION_EXTERN int *robot_connected, *d_robot_socket, *c_robot_socket;
COMMUNICATION_EXTERN int *camera_connected, *d_camera_socket, *c_camera_socket;
COMMUNICATION_EXTERN char *type_of_connected;
COMMUNICATION_EXTERN int robots, simulators;
COMMUNICATION_EXTERN REAL E, focus;

unsigned short send_joint_values(int nr, joint_values q, joint_values dq,
			joint_values ddq, int check_reach);
int get_joint_values(int nr, int wait,
			joint_values q, joint_values dq, joint_values ddq);
void send_robot(char msg);
short get_camera(int robot_nr, char cam_type, vector view_1, vector view_2);
void send_object_position(vector target);
void close_down(char m_robot, char m_camera);
void stop_robot(void);
void on_robot(void);
void on_camera(void);
void setup_communication(char *socketfile,
			int *control_socket, int *data_socket);
void send_data(int sock, char code, unsigned short length, char *data);
unsigned short receive_data(int sock, char **buffer, char *type);
int ciszero(REAL x);
int cispos(REAL x);
int cisneg(REAL x);


#endif
