/**************************************************************************/
/* client.c - socket setup routines for client side             /\/\      */
/* Version 1.1.0 -- June 1991                                   \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#include <stdio.h>
#include "socket.h"

#include "setup.h"


int setup_client_socket(socket_address, sock, host_name, wait)
int socket_address,	/* the socket address */
    *sock;		/* the socket file descriptor */
char *host_name;	/* name of host running server */
int wait;		/* indicate if it should wait for server */
{
  struct sockaddr_in	serverAddr;	/* server's address */
  struct sockaddr_in	clientAddr;	/* client's address */
  struct hostent	*host_entry;
  extern int errno;
  int waiting = 0;

  if (host_name == NULL)
  {
	fprintf(stderr, "CLIENT: no hostname\n");
	return -1;
  }

  if (socket_address <= 5000)
  {
	fprintf(stderr, "CLIENT: illegal socket address\n");
	return -1;
  }

  /* Zero out the sock_addr structures.
   * This MUST be done before the socket call.
   */

  bzero (&serverAddr, sizeof (serverAddr));
  bzero (&clientAddr, sizeof (clientAddr));

  /* Open the socket.
   * Use ARPA Internet address format and stream sockets.
   */

  while(wait)
  {
	*sock = socket (AF_INET, SOCK_STREAM, 0);

	if (*sock == ERROR)
	{
		perror("CLIENT");
		return -1;
	}

	serverAddr.sin_family = AF_INET;
	serverAddr.sin_port   = socket_address;	
 
	/* get server's Internet address */
 
	if ((serverAddr.sin_addr.s_addr = inet_addr (host_name)) == ERROR)
	{
		if ((host_entry = gethostbyname (host_name)) == NULL)
		{
			perror("CLIENT: invalid host");
			close (*sock);
			return -1;
		}

		serverAddr.sin_family = host_entry->h_addrtype;
		bcopy(host_entry->h_addr, (char *)&serverAddr.sin_addr,
			host_entry->h_length);
	}

	if (connect (*sock, &serverAddr, sizeof (serverAddr)) != ERROR)
		break;

	if (errno != ECONNREFUSED)
	{
		perror("CLIENT");
		return -1;
	}

	/* connect didn't work---server is not up yet.  Try again. */
	if (!waiting)
	{
		/* print message only if we're allowed to wait */
		if (wait) fprintf(stderr, "CLIENT: waiting for server\n");
		waiting = 1;
	}
	close (*sock);

	/* no need to sleep if we're going to stop anyway */
	if (wait) sleep(2);
  }

  /* waiting indicates if we were waiting (i.e., connect failed first time
     around); wait indicates if we were allowed to wait.
   */

  if (waiting && wait) fprintf(stderr, "CLIENT: connect succeeded\n");

  /* return error if connect didn't work but we're not allowed
     to try again.
   */
  if (waiting && !wait) return -1;

  return 0;
}
