/**************************************************************************/
/* communication.h                                              /\/\      */
/* Version 2.2.1 --  January 1992                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#ifndef _communication_h
#define _communication_h

#include "matrix.h"


#ifndef COMMUNICATION_EXTERN
#	define COMMUNICATION_EXTERN extern
#endif


void leave(void);
void panic_exit(void);
void init_server_communication(char *file);
void read_hmatrix(char *buffer, int length, unsigned short expected_nr, homo h);
void read_next_message(void);
void send_halt(void);
void close_down(char message);
void setup_communication(char *socketfile, int *control_socket, int *h_socket);
void send_data(int sock, char code, unsigned short length, char *data);
int receive_data(int sock, char **buffer, char *type);


COMMUNICATION_EXTERN int control_socket, PpPSoCkEt, connected;

#endif
