#define ENTITY_INPUTNODE		0
#define ENTITY_OUTPUTNODE		1
#define ENTITY_TRANSFORMATION	2
#define ENTITY_SUMMATION		3
#define ENTITY_DIFFERENCE		4
#define ENTITY_BIAS				5

#define MAX_PORTS		4
#define MAX_ENTITIES	100

#define PORT_INPUT	0
#define PORT_OUTPUT	1

#define POS_UP		0
#define POS_RIGHT	1
#define POS_DOWN	2
#define POS_LEFT	3

#define INPUTNODE_OUT	0

#define OUTPUTNODE_IN	0

#define TRANSFORMATION_IN	0
#define TRANSFORMATION_OUT	1

#define SUMMATION_INA	0
#define SUMMATION_INB	1
#define SUMMATION_OUT	2

#define DIFFERENCE_INA   0
#define DIFFERENCE_INB   1
#define DIFFERENCE_OUT   2

#define BIAS_OUT	0

#define MAX_TERMS	20

#define SCH_N	0
#define SCH_Z	1
#define SCH_P	2

#define NOISE_OFF	0
#define NOISE_ON	1

#define BIND_TO		 0
#define BIND_FROM 	 1
#define BIND_CURRENT 2

typedef struct {	
	int numterms;
	int zpower[MAX_TERMS];
	float coefficient[MAX_TERMS];
	} POLYNOMIAL;

typedef struct {
	int joint;		/* joint */
	int parameter;	/* parameter number */	
	int bind_mode;	/* BIND_? */
	double *value;	/* pointer to parameter value */
	int noise;		/* NOISE_ON or NOISE_OFF */
	double noise_scale;	/* noise scale factor */
	} INPUTNODE;

typedef struct {
	int joint;		/* joint */
	int parameter;	/* parameter number */
	int bind_mode;	/* BIND_? */
	double *value;	/* pointer to parameter value */
	} OUTPUTNODE;

typedef struct {
	char *top,*bot;			  /* top and bottom strings */
	double *ha,*hb;		  	  /* storage arrays for past */
	int lha,lhb;			  /* maximum length of storage */
	POLYNOMIAL *ptop,*pbot;	  /* top and bottom polynomial */
	int tx,ty,bx,by,lx,ly,ll; /* top, bottom, line x,y and line length */
	} TRANSFORMATION;

typedef struct {
	int junk;
	} SUMMATION;

typedef struct {
	int junk;
	} DIFFERENCE;

typedef struct {
	char *str;			/* value string */
	} BIAS;

typedef struct {
	char *name;					/* unique name */
	int type;					/* ENTITY_? */
	int x,y;					/* screen coordinates */
	int width,height;			/* screen size */
	long *a;
	void *entity;				/* pointer to an entity structure */
	double output;				/* output value */
	int numports;				/* number of ports */
	int mode[MAX_PORTS];		/* PORT_INPUT PORT_OUTPUT */
	int position[MAX_PORTS];	/* POS_? */
	int dx[MAX_PORTS];			/* dx and dy are relative positions */
	int dy[MAX_PORTS];			/* of port positions (in UDLR order */
	int c_entity[MAX_PORTS];	/* entity number for each port */
	int c_port[MAX_PORTS];		/* port number for each port */
	char *pname[MAX_PORTS];		/* port name */
	} ENTITY;

extern ENTITY *entity[MAX_ENTITIES];
extern int numentities;

extern long schematic_step;
extern long schematic_x,schematic_y;
