#define PI 3.14159265358979323846264338327950288

typedef double mat[4][4];
typedef struct {
	double d;
	double alpha;
	double theta;
	double a;
	} link;

#define MAXLINKS 100
extern link links[MAXLINKS];
extern int numlinks;

/* graphics from here down */

#define WORLD_SIMPLE	0
#define WORLD_COMPLEX	1

typedef struct{
    float wx,wy,wz;
    float xdx,xdy,xdz;
    float ydx,ydy,ydz;
    int x,y;
    long *colour;
    } PICTURE;

#define MAX_PICTURES 20
extern int numpictures;
extern PICTURE *picture[MAX_PICTURES];

#ifdef R_SGI
extern Matrix Identity;
#endif

#define MAT_PANEL	1
#define MAT_FLOOR	2
#define MAT_WALL	3

#define MAT_USER	16		/* from 16 on are user defineable Materials */
#define MAT_BOX		48

#define FLOOR_SIZE 2.0

extern float mat_panel[];
extern float mat_floor[];
extern float mat_wall[];
extern float lm[];
extern float lt[];

/* New structures */

#define RMODE_NONE			0
#define RMODE_USER			1
#define RMODE_SCHEMATIC		2
#define RMODE_USERSCHEMATIC	3

#define ROB_SET		0		/* set, cannot change */
#define ROB_CON		1		/* controlled by user */

#define ROB_ANGLE	0		/* Angle variable */
#define ROB_DIST	1		/* distance variable */

#define SIM_V		0		/* control variables directly 	*/
#define SIM_VD		1		/* control V_dot				*/
#define SIM_VDD		2		/* control V_dotdot				*/
#define SIM_F		3		/* control forces				*/
#define SIM_NONE	4		/* no control over parameters	*/

#define MAX_JOINTS	100
#define MAX_VARIABLES 4*MAX_JOINTS
#define MAX_GRAPHS	40

#define MODE_FROM	0
#define MODE_TO		1
#define MODE_RUN	2
#define MODE_PAUSE	3
#define MODE_RESET	4

#define PAR_X		0
#define PAR_Y		1
#define PAR_Z		2
#define PAR_XD		3
#define PAR_YD		4
#define PAR_ZD		5
#define PAR_DX		6
#define PAR_DY		7
#define PAR_DZ		8
#define PAR_DXD		9
#define PAR_DYD		10
#define PAR_DZD		11
#define PAR_A		12
#define PAR_D		13
#define PAR_ALPHA	14
#define PAR_THETA	15
#define PAR_AD      16
#define PAR_DD      17  
#define PAR_ALPHAD  18
#define PAR_THETAD  19
#define PAR_ADD     20
#define PAR_DDD     21   
#define PAR_ALPHADD 22
#define PAR_THETADD 23
#define PAR_FA      24
#define PAR_FD      25  
#define PAR_FALPHA  26
#define PAR_FTHETA  27

#define GMODE_AUTO	0
#define GMODE_FIXED	1

#define GS_JOINT	0
#define GS_ENTITY	1

typedef struct {
	/* world variables */
	double a,d,alpha,theta;			/* DH Frame Variables 		*/
	double ad,dd,alphad,thetad;		/* Time derivative 			*/
	double add,ddd,alphadd,thetadd;	/* Time second derivative	*/
	double x,y,z;					/* joint position			*/
	double xd,yd,zd;				/* position derivative		*/
	double dx,dy,dz;				/* joint vector				*/
	double dxd,dyd,dzd;				/* joint vector derivative	*/
	double fa,fd,falpha,ftheta;		/* joint forces				*/
	double fric_ad,fric_ads,fric_amin;		       /* friction coefficients	*/
	double fric_dd,fric_dds,fric_dmin;		       /* friction coefficients	*/
	double fric_alphad,fric_alphads,fric_alphamin; /* friction coefficients	*/
	double fric_thetad,fric_thetads,fric_thetamin; /* friction coefficients	*/
	double J[4][4];					/* Inertia Tensor			*/
	int sim_mode;					/* SIM_V SIM_VD SIM_VDD SIM_F */

	/* simulator variables and flags */
	int ca,cd,calpha,ctheta;	/* flags, ROB_CON, ROB_SET	*/
	int a_var,d_var,alpha_var,theta_var;	/* variable numbers if ROB_CON */
	char *name;					/* joint name */
	int a_alpha,a_theta;		/* arrow number, if valid */
	int s_a,s_d;				/* slidebar number, if valid */
	
	/* graphics parameters */
	float radius;
	int numpanels;
	float *material;
	} JOINT;

typedef struct {
	char *name;
	int type;	/* ROB_ANGLE, ROB_DIST */
	double value;
	double min,max;	/* always bounded */
	} VARIABLE;

typedef struct {
	int source;							/* GS_JOINT or GS_ENTITY			*/
    int num;  		                   	/* joint/entity number          	*/
    int type;                          	/* parameter type PAR_??           	*/
    float *graph;                     	/* pointers to value array         	*/
	double *value;						/* pointer to value (saves deref)  	*/
    long rgb;                          	/* rgb values for graphing/text 	*/
	} GPARAMETER;

typedef struct {
	char *name;							/* graph's name */
	int x,y,width,height;				/* full window size for graph */
	float vertical_min,vertical_max;	/* window size */
	int vertical_mode;					/* GMODE_AUTO, GMODE_FIXED */
	int vertical_labels;				/* number of vertical labels */
	double horizontal_scale;			/* fixed->sliding, auto->scaling */
	int horizontal_mode;				/* GMODE_AUTO, GMODE_FIXED */
	int horizontal_labels;				/* number of horizontal labels */
	
	long *wout,*win;					/* outside and inside of graph */
	
	int num_parameters;					/* number of parameters to graph */
	GPARAMETER **parameter;				/* parameter lists */
	} GRAPH;

extern long wid_visual,wid_control,wid_graph,wid_schematic;

extern JOINT *joint[MAX_JOINTS];			/* current position joints */
extern JOINT *pjoint[MAX_JOINTS];			/* previous position joints */
extern JOINT *from_joint[MAX_JOINTS];		/* from position joints */
extern JOINT *to_joint[MAX_JOINTS];		/* to positions joints */
extern int numjoints;
extern VARIABLE *variable[MAX_VARIABLES];
extern int numvariables;
extern GRAPH *graph[MAX_GRAPHS];
extern int numgraphs;

extern double time_step,current_time,time_bound_min,time_bound_max;
extern int step_num,step_count;
extern float actual_time[10000];			/* array of time values 	*/

extern int global_mode;
extern JOINT **global_joint;

#define HOFF    220     /* offset for control panel */

extern int graph_active;				/* graph on or not */
extern int graph_width,graph_height;	/* window width and height */

extern int robot_created;	/* true if setup_joints has been called, */
							/* false means from and to not created	 */

extern int runmode;			/* controls overall runmode, RMODE_? */
extern int world_mode;		/* controls graphics detail level */

extern char *save_name;
extern char *schematic_print_name;

extern int visual_mode;		/* CKEY, VISUAL_? */
#define VISUAL_MOBILE	0
#define VISUAL_ORIGIN	1

/* POPUP MENU STUFF */

extern long control_menu,visual_menu,schematic_menu,graph_menu;

#define SAVE_FROM   1
#define SAVE_TO     2
#define SAVE_PATH	3
#define RESET_PATH	4

#define VIEW_WORLD  1
#define VIEW_LOCAL  2

#define SCHEMATIC_SAVE 1
#define SCHEMATIC_PRINT 2

#define GRAPH_SAVE	1
#define GRAPH_PRINT	2

/* END OF MENU STUFF */

extern long graph_x,graph_y,graph_step;

/* BOXES */

typedef struct {
	char *name;
	float x,y,z;		/* position center, top face */
	float dx,dy,dz;		/* width, depth, height */
	float *material;
	} BOX;

#define MAX_BOXES	20
BOX *box[MAX_BOXES];
extern int numboxes;

#define MAX_PATH	10000
extern float path_x[MAX_PATH];	/* actual path */
extern float path_y[MAX_PATH];	/* actual path */
extern float path_z[MAX_PATH];	/* actual path */
extern int pathnum;				/* number of valid path entries */
extern int plan_passes;			/* expansion passes */

extern float plan_sx,plan_sy,plan_sz;	/* start of volume */
extern float plan_ex,plan_ey,plan_ez;	/* end of volume */
extern int plan_nx,plan_ny,plan_nz;		/* number of voxels */

extern float arm_length,arm_x,arm_y,arm_z;
