/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          MATMUL.C                                                          **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<math.h>
#include<stdio.h>
#ifdef R_SGI
#include<gl.h>
#endif
#include"windowlib.h"
#include"rob.h"

link links[MAXLINKS];
int numlinks;

/* Multiplies A(m*n) by B (n*o) to give C (m*o) */

void minimul(double **A,double **B,double **C,int m,int n,int o)
{
   	unsigned short i,j,k;
	for (i=0;i<m;i++) {
		double *row=A[i];
		double *res=C[i];
		for (k=0;k<o;k++) res[k]=0;
		for (j=0;j<n;j++) { 
			double val=row[j];
			double *col=B[j];
			for (k=0;k<o;k++) res[k]+=val*col[k]; 
		}
   	}
}

int domul(double *arrayA,double *arrayB,double *arrayC,int m,int n,int o)
{
   double **A,**B,**C;
   unsigned short i;
   int status=1;

   A=(double **)malloc(m*sizeof(double *));
   B=(double **)malloc(n*sizeof(double *));
   C=(double **)malloc(m*sizeof(double *));
   
   status=!!C;
   if (status) {
   	for (i=0;i<m;i++) A[i]=arrayA+n*i;
   	for (i=0;i<n;i++) B[i]=arrayB+o*i;
   	for (i=0;i<m;i++) C[i]=arrayC+o*i;
	minimul(A,B,C,m,n,o);
   } else {
	printf("Out of memory in domul\n");
   }
   if (C) free(C);
   if (B) free(B);
   if (A) free(A);
   return status;
}

int mul4(mat A,mat B,mat C)
{
	return domul(A[0],B[0],C[0],4,4,4);
}

/* print out A (m*n) */

void print(double *A,int m,int n)
{
	unsigned short i,j;
	
	for (i=0;i<2+8*n;i++) printf("-");
	printf("\n");
	for (i=0;i<m;i++) {
		printf("| ");
		for (j=0;j<n;j++) {
			printf("%6.3f |",A[i*n+j]);
		}
		printf("\n");
	}
	for (i=0;i<2+8*n;i++) printf("-");
	printf("\n");
}

void print4(mat A) {print(A[0],4,4);}

void identity(mat A)  /* make A identity */
{
	unsigned short i,j;
	for (i=0;i<4;i++) for (j=0;j<4;j++) A[i][j]=i==j;
}

void copy(mat A,mat B) /* Copy A onto B */
{
	unsigned short i,j;
	for (i=0;i<4;i++) for (j=0;j<4;j++) B[i][j]=A[i][j];
}


void makeA(mat A,link *l)  /* make a transition matrix */
{
	double ct=cos(l->theta);
	double st=sin(l->theta);
	double ca=cos(l->alpha);
	double sa=sin(l->alpha);
	double a=l->a;
	double d=l->d;
	
	A[0][0]=ct;
	A[0][1]= -st*ca;
	A[0][2]=st*sa;
	A[0][3]=a*ct;
	A[1][0]=st;
	A[1][1]=ct*ca;
	A[1][2]= -ct*sa;
	A[1][3]=a*st;
	A[2][0]=0;
	A[2][1]=sa;
	A[2][2]=ca;
	A[2][3]=d;
	A[3][0]=0;
	A[3][1]=0;
	A[3][2]=0;
	A[3][3]=1;
}

void joints_to_links()	
{
	int i;

	for(i=0;i<numjoints;i++) {
		links[i].a=global_joint[i]->a;
		links[i].d=global_joint[i]->d;
		links[i].alpha=global_joint[i]->alpha;
		links[i].theta=global_joint[i]->theta;
	}
	numlinks=numjoints;
}

void calculate_position()
{
    mat A,B,R;
    unsigned short i;
    float a[3];

    identity(R);
    for (i=0;i<numlinks;i++) {
        makeA(A,links+i);
        copy(R,B);
        mul4(B,A,R);
        a[0]=R[0][3];
        a[1]=R[1][3];
        a[2]=R[2][3];
		global_joint[i]->x=a[0];
		global_joint[i]->y=a[1];
		global_joint[i]->z=a[2];
    }
}

