/* #########################################
 * wake.c
 *
 * draw a wake of the robot
 *
 *#########################################
 */

#include "structures.h"
#include "constants.h"
#include "parameters.h"

cbuf wbuf;			/* holds wake readings */
int draw_wake_flag = 0;
int wake_count = 0;
#define WAKE_NUM 10

empty_wbuf(n)			/* set up buffer */
{
  wbuf.start = 0;
  wbuf.end = 0;
  if (n < CBUF_LEN) wbuf.limit = n;
  else wbuf.limit = (CBUF_LEN - 1);
}

add_wbuf(float x,float y)	/* add the entry, rw coords */
{
  int end, st, mx;
  end = wbuf.end; st = wbuf.start; mx = wbuf.limit;
  wbuf.xbuf[end] = x;		/* add the entry */
  wbuf.ybuf[end] = y;
  end++;
  if (end > mx) end = 0;	/* check end of circular buffer */
  if (end == st)		/* need to delete oldest entry */
    { st++; if (st > mx) st = 0; }
  wbuf.end = end; wbuf.start = st;
}


display_wbuf(int n)		/* draw wake, n is box size */
{
  int i;
  int st, end, mx;
  float *xbuf, *ybuf;
  xbuf = wbuf.xbuf;    ybuf = wbuf.ybuf;
  st = wbuf.start; end = wbuf.end; mx = wbuf.limit;
  for (i = st; i != end; i++)
    { if ( i > mx ) { i = -1; continue; }
      draw_sonar_pt(xbuf[i],ybuf[i],n);
    }
}

update_wbuf(float dx,float dy,float dth) /* decrement by this amount, rw coords */
{
  int st, end, mx;
  float *xbuf, *ybuf;
  int i;
  float cth, sth;
  float tx, ty;
  int n;
  sdata *r;

  if (draw_wake_flag)
    {
      dth = - dth;		/* historical reasons... */
      cth = cos(dth);		/* we should only do this when dth > 0... */
      sth = sin(dth); 

      xbuf = wbuf.xbuf;    ybuf = wbuf.ybuf;
      st = wbuf.start; end = wbuf.end; mx = wbuf.limit;
      for (i = st; i != end; i++)
	{ if (i > mx) {if (end == 0) { break; } 
	else {i = -1; continue; }}	/* reset if beyond the end */
	  tx = xbuf[i] - dx;
	  ty = ybuf[i] - dy;
	  xbuf[i] = (tx * cth) - (ty * sth);
	  ybuf[i] = (ty * cth) + (tx * sth);
	}
    }
}

init_wake()			/* initialize everything */
{
  empty_wbuf(50);
  wake_count = 0;
}

draw_wake()			/* draw the wake, if needed */
{
  if (draw_wake_flag)
    display_wbuf(1);
}


wake_proc()
{
  if (draw_wake_flag)
    {
      if (flakey.status == STATUS_MOVING)
	{
	  if (wake_count++ > WAKE_NUM)
	    {
	      wake_count = 0;
	      add_wbuf(flakey.x,flakey.y);
	    }
	}
    }
}
	  
