/*#########################################
 * toplevel.c
 *
 * Top level fns for the FLAKEY controller
 *
 *#########################################
 */

#include <stdio.h>
#include "display.h"
#include "structures.h"
#include "constants.h"
#include "parameters.h"


void process_events();

int debug = 0;
extern int trace_packets;
extern int trace_commands;
int idle_time = 0;		/* total idle time in loop */
extern int num_bcs;

extern void
test_control_proc(int reset);

main(argc,argv)			/* starts up Flakey window */
     int argc; char **argv;
{
  init_window(500,400,.06,argc,argv);
  connected = 0;
  while (1)
    {
      reset_flakey_vars();
      message("No connection");
      while (!connected)
	{
	  process_events();
	  check_connection();
	  draw_flakey();
	  display_buffer();
	  int_time(100);
	}
      message("opening motor controller...");
      flakey.status = STATUS_NO_HIGH_POWER;
      trace_packets = 0;
      trace_commands = 0;
      pointlist_p = 0;		/* clear global point list */
      test_control_proc(1);	/* reset it */
      num_bcs = 0;
      if (open_motor_controller(1,1) >= 0)
	{ message("Opened"); }
      command_to_flakey_i(POLLING_COM,ALL_ARG);
      while(connected)
	{
	  update_and_comm();
	  process_events();
	  idle_time += int_time(100);
	}
    } 
}


char *hostname = NULL;

check_connection()
{
  if (hostname != NULL)
    {
      if (strncmp(hostname,"/dev/tty",8) == 0) /* use tty port here */
	startup_flakey_server(TTYPORT,hostname);
      else
	startup_flakey_server(TCP,hostname);
      if (connected)		/* succeeded */
	{
	  set_disconnect_state();
	}
      hostname = NULL;
    }
}

update_and_comm()		/* process robot movements, send commands */
{
  pulse_proc();			/* pulse robot for info */
  process_waiting_packets();
  motor_proc();			/* send motor commands */
  clamp_proc();			/* clamp to local coords */
  sonar_proc();			/* add in new sonar readings */
  wake_proc();			/* check wake stuff */
  test_control_proc(0);
  draw_proc();
}


pulse_proc()			/* send motor/sonar info pulses */
{
  static int i = 0;
  i++;
  if (i > 9)
    {
      command_to_flakey_i(PULSE_COM,SONAR_ARG | MOTOR_ARG | 0xF00);
      i = 0;
    }
}


draw_proc()			/* draws relevant info */
{
  reset_flakey_matrix();	/* reset the flakey drawing matrix */
  draw_flakey();
  draw_veloc();
  draw_status();
  draw_sonars();
  draw_wake();
  draw_behaviors();
  draw_pointlist();
  display_buffer();
}

