/* 
 * robot.c -- functions for initialization of the robot controller
 * 
 */

#include <stdio.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"


robot flakey;			/* this is the robot controller data structure */

extern int single_step_mode;

reset_flakey_vars()		/* reset all robot parameters */
{
  int i;

  flakey.x = flakey.y = flakey.th = 0.0;
  flakey.leftv = flakey.rightv = flakey.rv = flakey.tv = 0.0;
  flakey.status = STATUS_NOT_CONNECTED;

  flakey.acc = 200.0;
  flakey.mtv = 500.0;
  flakey.mrv = 1.5;		/* current acceleration and velocity maximums */

  flakey.motor_packet_count = flakey.sonar_packet_count 
        = flakey.vision_packet_count = 0;

  flakey.battery = 250;		/* level in tenths of a volt */
  flakey.bumpers = 0;		/* bumper mask */
  flakey.control = 0.0;		/* heading control, in rads */
  flakey.say = 0;		/* acknowledgment of SAY commands */

  for (i=0; i<MAX_SONARS; i++)
    {
      sbucket[i].new = False;
    }

  reset_flakey_matrix();	/* transformation matrices */

  empty_sbuf(0,40);		/* circular buffers for sonars */
  empty_sbuf(1,40);

  single_step_mode = 0;
}


