/*  RETINA_PATH.P  */


section retina_path => retina_path;


/*
SPECIFICATION
-------------


This module finds a path within an retina, using hill-climbing search. A
``retina'' is a ....
of its world. For a description of RETINAs and the operations on them, see
HELP RETINA.

The module defines one routine, retina_path:


PUBLIC retina_path( retina, start, goal, safe ):

Searches for a path from start to goal within retina. The procedure safe
determines which points can be traversed and which are treated as
obstacles. The path is returned as a list of points whose first element
is start and whose final element is goal. Each point is represented as a
two-element list [%x,%y]. If there is no path, the procedure returns
false.

safe must be a procedure of three arguments, safe(retina,x,y) returning
true or false. It returns true if retina(x,y) is passable, and false if
it is an obstacle. You will usually want to define it as
    define safe(retina,x,y);
        lvars retina, x, y;
        retina(x,y) = ` `
    enddefine;


See HELP AWM_PATH for a description of the search method.
*/


/*
IMPLEMENTATION
--------------
...
*/


needs utils;
needs vec;
needs retina;
needs search;
needs awm;
needs awm_path;


define global retina_path( retina, start, goal, safe );
    lvars retina, start, goal, safe;

    lvars awm, awm_start, awm_goal, path, loc;

    new_awm(`?`) -> awm;
    awm_merge_retina( awm, retina );
    awm_retina_coords_to_awm_coords( awm, start ) -> awm_start;
    awm_retina_coords_to_awm_coords( awm, goal ) -> awm_goal;
    awm_path( awm, awm_start, awm_goal, safe ) -> path;
    if path /= false then
        [%
            for loc in path do
                awm_awm_coords_to_retina_coords( awm, loc );
            endfor;
        %]
    else
        path
    endif;
enddefine;


define test();
    define safe(awm,x,y);
        lvars awm, x, y;
        true
    enddefine;
    retina_path( retina(), [3 1], [3 3], safe );
enddefine;


endsection;
