/*  EXEC.P  */


/*
SPECIFICATION
-------------

This module provides facilities for writing ``brains'' for Eden that, as
far as they are concerned, run continuously, rather than starting afresh
on each call to 'think'. In effect, it provides a simple form of
coroutine. Experienced Poplog programmers will see that it is a very
simple interface to LIB PROCESS (see HELP PROCESS): I have written it so
that novices can write co-routine style brains without having to know
anything more about LIB PROCESS.


You can make a procedure into a process by calling
    proc_to_process( proc ) -> co;

You can then start running it by calling
    restart_process( co );

Eventually, proc should call
    exec( a )
where a is an action. This will get passed back as the result of
'restart_process'. 'proc' will stop running, and return control to just after
this call of 'restart_process'. To start 'proc' from where it left off, call
'restart_process' again.


PUBLIC proc_to_process( proc ):

Converts proc into a process, returned as the result.


PUBLIC restart_process( co ):

Runs 'co' until it calls exec(action). 'action' is then returned as the
result of 'restart_process', and 'co' suspends itself, as described
above. 'co' can either be a process which has not been run before, or
one which has, and is suspended.


PUBLIC exec( action ):

Called from inside 'proc' to suspend and return an action.


Example:

    vars co;

    define start_thinking();
        proc_to_process( brain ) -> co;
    enddefine;

    define think();
        restart_process( co );
    enddefine;

    define brain();
        repeat
            if smell() = "here" then
                exec( "grab");
                exec( "use" )
            else
                exec( smell() )
            endif;
        endrepeat;
    enddefine;

    define bugdead();
        start_thinking();
        "rerun";
    enddefine;

This bug can be found in EXEC_BUG.P.        
*/


/*
IMPLEMENTATION
--------------

This relies on the process feature. See REF PROCESSES.

This library has a HELP file, HELP EXEC. Keep it in step with the code.
*/


define exec( action );
    lvars action;
    suspend( action, 1 );
enddefine;


define restart_process( co );
    lvars co;
    runproc( 0, co );
enddefine;


define proc_to_process( proc );
    lvars proc;
    consproc( 0, proc );
enddefine;
