/*                     SEARCH_

    The base class SEARCH_ defines a skeleton search class from
    which the actual search classes such as DEPTH_GRAPH_ are
    derived. This means that SEARCH_ should never (have to) be used
    for direct derivation!

    Essentially, this class implements two linked lists of NODE_ *
    objects: open and closed. Open contains nodes that are ready for
    expansion and closed contains nodes that already have the expansion
    procedure applied to them.

    Every class that is (indirectly!) derived from SEARCH_ must pass
    the start node, goal node and the number of operators to the
    constructor of SEARCH_ (or rather, to the search class derived from
    SEARCH_).

    N.B. the objective of add() is to add a new node to the list
    according to a specific strategy, it is used by those classes
    that are directly derived from SEARCH_, like DEPTH_GRAPTH_ etc.
*/
 
#ifndef _search_H_
#define _search_H_

#include <stdio.h>
#include "object.h"
#include "nodes.h"
#include "list.h"

class SEARCH_
{
    public:
        SEARCH_(NODE_ *start, NODE_ *goal, int numop);
	virtual ~SEARCH_();

        void generate();     // starts search process 
        NODE_ *solve();      // actual search engine in combination with add()
        void print_sol(NODE_ *) const;      // prints solution

        virtual int add(NODE_ *) = 0;       // adds node to open 
    private:
        int num_op;			    // number of operators to be used
	NODE_ *goalnode;
    protected:     // protected since several classes need access through add() 
        SORTEDLIST_ open,
                    closed;
};

#endif
