#include <stdio.h>
#include "graph.h"


/*                     DEMO3

    In this problem we solve a 'real' 8-puzzle. Unlike demo1 we're
    not just interested in the position of the empty tile, but want
    to know exactly which tiles have to be moved to transform
    the start configuration into the goal configuration.

*/



/*                     PNODE

    Class PNODE_ defines objects representing a board configuration.

*/

class PNODE_ : public NODE_
{
    public:
        PNODE_(const char *, int empty_x, int empty_y);
        PNODE_(const char *, int, int, int, int);
        int get_x() const;
        int get_y() const;
        const char *get_board() const;

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;
        void display() const;
        NODE_ *do_operator(int) const;
    private:
        PNODE_
            *do_left() const,
            *do_right() const,
            *do_up() const,
            *do_down() const;
            int compare_board(const char *) const;
        int
            x,                    // coordinates of empty tile.
            y;
        char
            board[3][3];          // array to represent board configuration
};


class PUZZLE_ : public DEPTH_GRAPH_
{
    public:
        PUZZLE_(PNODE_ *start, PNODE_ *target);
};


