#include "demo3.h"

PUZZLE_::PUZZLE_(PNODE_ *start, PNODE_ *target)
    :DEPTH_GRAPH_(start, target, 4)
{
}


/*                 PNODE

    Initializes a PNODE_ object.

*/

PNODE_::PNODE_(const char *b, int empty_x, int empty_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i);

    x = empty_x;
    y = empty_y;
}



/*                       PNODE_

    Initializes a new configuration using it's 'parent' configuration.
    First copies the old board and then swaps the two tiles that are
    on old_x, old_y and new_x, new_t respectively.

*/

PNODE_::PNODE_(const char *b, int old_x, int old_y, int new_x, int new_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i); 

    board[old_x][old_y] = board[new_x][new_y];
    board[new_x][new_y] = 0;

    x = new_x;
    y = new_y;
}



/*                    DISPLAY

    Displays a board configuration.

*/

void PNODE_::display() const
{
    int
        row,
        col;

    for (row = 0; row < 3; row++)
    {
        for (col = 0; col < 3; col++)
            printf("%d ", board[row][col]);
        putchar('\n');
    }
    putchar('\n');
}



/*                    EQUAL

    Determines if two nodes, i.e., two board positions are the same.
    First, the x- and y-coordinates of the empty tile are compared
    and next, if necessary, the two boards themselves.

*/

int PNODE_::equal(const VOBJECT_ &other) const
{
     if (x != ((const PNODE_ &)other).get_x()
          && y != ((const PNODE_ &)other).get_y())
            return(0);
    return(compare_board(((const PNODE_ &)other).get_board()));
}



const char *PNODE_::get_board() const
{
    return(*board);
}



int PNODE_::get_x() const
{
    return(x);
}



int PNODE_::get_y() const
{
    return(y);
}



/*                   COMP_BOARD

    Compares the current board configuration with another. Could
    have used memcmp() here.

*/ 

int PNODE_::compare_board(const char *b) const
{
    const char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        if (*(p + i) != *(b + i))
            return(0);

    return(1);
}



/*                 DO_OPERATOR

    Applies operator n to the current configuration, i.e. it moves
    the empty tile (by calling one of the do_..() functions) resulting
    in a new board configuration or NULL if the operator can't be applied.

*/

NODE_ *PNODE_::do_operator(int index) const
{
    switch(index)
    {
        case 0:
            return(do_down());
        case 1:
            return(do_up());
        case 2:
            return(do_right());
    }
    return(do_left());
}



PNODE_ *PNODE_::do_left() const
{
    if (!y)
        return(NULL);

    return(new PNODE_(*board, x, y, x, y - 1));
}



PNODE_ *PNODE_::do_right() const
{
    if (y == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x, y + 1));
}



PNODE_ *PNODE_::do_up() const
{
    if (!x)
        return(NULL);

    return(new PNODE_(*board, x, y, x - 1, y));
}



PNODE_ *PNODE_::do_down() const
{
    if (x == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x + 1, y));
}



int main()
{
    char
        start[3][3] = {
                        {1, 3, 4},
                        {8, 0, 2},
                        {7, 6, 5},
                      };

    char
        goal[3][3] = {
                        {1, 2, 3},
                        {8, 0, 4},
                        {7, 6, 5},
                    };

    PUZZLE_
        puzzle(new PNODE_(*start, 1, 1), new PNODE_(*goal, 1, 1));

    puzzle.generate();
    return(1);
}
