;;; -*- Package: Ra-1-User-Interface; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

;;; File converted on  3-Nov-87 16:29:51 from source MAKE-TRACE-WINDOW
;;; Original source {LISPDEV:LAIR:OHIO-STATE}<TOOLSET>RA-1>MAKE-TRACE-WINDOW.;1 created  3-Nov-87 16:30:07


(DEFUN MAKE-TRACE-WINDOW (BLOCK FEATURES CONFIDENCES NO-MATCH 
                                DRAGON-NAME) "Sets up a trace window"
   (LET
    ((TRACE-WINDOW (MAKE-INSTANCE 'RA-1-TRACE))
     REGION-WIDTH REGION-HEIGHT (FONT-HEIGHT (IL:FONTPROP IL:SMALLFONT
                                                    'IL:HEIGHT)))
    (PCL::WITH-SLOTS* (ELEMENT-ARRAY ROW-HEADINGS CONFIDENCE-VALUES
				     OTHERWISE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-WIDTH
				     GRID-HEIGHT GRID-LEFT-EDGE
				     GRID-BOTTOM-EDGE REGION WINDOW)
		      TRACE-WINDOW
                                           ; use slots transparently

     (SETF ELEMENT-ARRAY BLOCK)
     (SETF ROW-HEADINGS FEATURES)
     (SETF CONFIDENCE-VALUES CONFIDENCES)
     (SETF OTHERWISE NO-MATCH)
       
       ;; compute grid dimensions

     (SETF
      GRID-ELEMENT-WIDTH
      (+
       4
       (*
        (IL:CHARWIDTH 87 IL:SMALLFONT)
        (DO
         ((ROW-COUNTER 0 (1+ ROW-COUNTER))
          (LARGEST 0))
         ((> ROW-COUNTER (1- (ARRAY-DIMENSION BLOCK 0)))
          LARGEST)
         (SETQ LARGEST
               (MAX LARGEST (LENGTH (PRINC-TO-STRING (AREF CONFIDENCES 
                                                           ROW-COUNTER)
                                           ))
                    (DO ((COLUMN-COUNTER 0 (1+ COLUMN-COUNTER))
                         (LARGEST 0))
                        ((> COLUMN-COUNTER (1- (ARRAY-DIMENSION BLOCK 1
                                                      )))
                         LARGEST)
                        (SETQ LARGEST
                              (MAX LARGEST
                                   (LENGTH (WRITE-TO-STRING
                                            (AREF BLOCK ROW-COUNTER 
                                                  COLUMN-COUNTER)))))))
               )))))
     (SETF GRID-ELEMENT-HEIGHT (+ 5 FONT-HEIGHT))
     (SETF GRID-WIDTH (1+ (ARRAY-DIMENSION BLOCK 1)))
     (SETF GRID-HEIGHT (ARRAY-DIMENSION BLOCK 0))
     (SETF GRID-LEFT-EDGE (ROUND (/ GRID-ELEMENT-WIDTH GRID-WIDTH)))
     (SETF GRID-BOTTOM-EDGE (+ (* 2 FONT-HEIGHT)))
       
       ;; compute region dimensions

     (SETF
      REGION-WIDTH
      (ROUND
       (+
        (MAX
         (* (IL:CHARWIDTH 87 IL:SMALLFONT)
            (LET ((LARGEST 0))
                 (DO ((COUNTER 0 (1+ COUNTER)))
                     ((> COUNTER (1- (ARRAY-DIMENSION FEATURES 0))))
                     (SETF LARGEST
                           (MAX LARGEST (LENGTH (WRITE-TO-STRING
                                                 (AREF FEATURES COUNTER
                                                       ))))))
                 LARGEST))
         (* GRID-WIDTH GRID-ELEMENT-WIDTH))
        (* 2 (/ GRID-ELEMENT-WIDTH GRID-WIDTH)))))
     (SETF REGION-HEIGHT (ROUND (+ (* FONT-HEIGHT
                                      (+ (ARRAY-DIMENSION FEATURES 0)
                                         4))
                                   (* GRID-HEIGHT GRID-ELEMENT-HEIGHT)
                                   (* 2 (/ GRID-ELEMENT-HEIGHT 
                                           GRID-HEIGHT)))))
     (SETF REGION (LIST (RANDOM (ABS (ROUND (/ (- IL:SCREENWIDTH 
                                                  REGION-WIDTH)
                                               2))))
                        (RANDOM (ABS (ROUND (/ (- IL:SCREENHEIGHT 
                                                  REGION-HEIGHT)
                                               2))))
                        REGION-WIDTH REGION-HEIGHT))
       
       ;; open window and draw grid

     (SETF WINDOW (IL:CREATEW REGION (CONCATENATE 'STRING DRAGON-NAME 
                                            " - Trace")
                         1))
     (IL:DSPOPERATION 'IL:PAINT WINDOW)
     (IL:CHANGEFONT IL:SMALLFONT WINDOW)
     (IL:GRID (LIST GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH 
                    GRID-ELEMENT-HEIGHT)
            GRID-WIDTH GRID-HEIGHT 1 WINDOW)
       
       ;; draw element array

     (DO
      ((ROW-COUNTER 0 (1+ ROW-COUNTER)))
      ((> ROW-COUNTER (1- (ARRAY-DIMENSION BLOCK 0))))
      (IL:DSPYPOSITION (+ GRID-BOTTOM-EDGE
                          (* GRID-ELEMENT-HEIGHT
                             (- (ARRAY-DIMENSION BLOCK 0)
                                ROW-COUNTER 1)))
             WINDOW)
      (DO
       ((COLUMN-COUNTER 0 (1+ COLUMN-COUNTER)))
       ((> COLUMN-COUNTER (1- (ARRAY-DIMENSION BLOCK 1))))
       (IL:DSPYPOSITION (+ GRID-BOTTOM-EDGE
                           (* GRID-ELEMENT-HEIGHT
                              (- (ARRAY-DIMENSION BLOCK 0)
                                 ROW-COUNTER 1))
                           3)
              WINDOW)
       (IL:DSPXPOSITION
        (+ GRID-LEFT-EDGE (* COLUMN-COUNTER GRID-ELEMENT-WIDTH)
           (ROUND (/ (- GRID-ELEMENT-WIDTH
                        (* (LENGTH (WRITE-TO-STRING (AREF BLOCK 
                                                          ROW-COUNTER 
                                                         COLUMN-COUNTER
                                                          )))
                           (IL:CHARWIDTH 87 IL:SMALLFONT)))
                     2)))
        WINDOW)
       (IL:PRINT (AREF BLOCK ROW-COUNTER COLUMN-COUNTER)
              WINDOW)))
       
       ;; draw features array

     (DO
      ((COUNTER 0 (1+ COUNTER)))
      ((> COUNTER (1- (ARRAY-DIMENSION CONFIDENCE-VALUES 0))))
      (IL:DSPYPOSITION (+ GRID-BOTTOM-EDGE
                          (* GRID-ELEMENT-HEIGHT
                             (- (ARRAY-DIMENSION CONFIDENCE-VALUES 0)
                                COUNTER 1))
                          3)
             WINDOW)
      (IL:DSPXPOSITION
       (+ GRID-LEFT-EDGE (* GRID-ELEMENT-WIDTH (1- GRID-WIDTH))
          (ROUND (/ (- GRID-ELEMENT-WIDTH
                       (* (LENGTH (WRITE-TO-STRING (AREF 
                                                      CONFIDENCE-VALUES 
                                                         COUNTER)))
                          (IL:CHARWIDTH 87 IL:SMALLFONT)))
                    2)))
       WINDOW)
      (IL:PRINT (AREF CONFIDENCE-VALUES COUNTER)
             WINDOW))
       
       ;; print the feature headings

     (DO ((COUNTER 0 (1+ COUNTER)))
         ((> COUNTER (1- (ARRAY-DIMENSION FEATURES 0))))
         (IL:DSPXPOSITION 5 WINDOW)
         (IL:DSPYPOSITION (- REGION-HEIGHT (* (+ COUNTER 2)
                                              FONT-HEIGHT))
                WINDOW)
         (IL:PRIN1 (CONCATENATE 'STRING (WRITE-TO-STRING (1+ COUNTER))
                          " : "
                          (WRITE-TO-STRING (AREF FEATURES COUNTER)))
                WINDOW)
         (IL:DSPXPOSITION
          (+ GRID-LEFT-EDGE (* GRID-ELEMENT-WIDTH COUNTER)
             (ROUND (/ (- GRID-ELEMENT-WIDTH (* (LENGTH (
                                                        WRITE-TO-STRING
                                                         COUNTER))
                                                (IL:CHARWIDTH 87 
                                                       IL:SMALLFONT)))
                       2)))
          WINDOW)
         (IL:DSPYPOSITION (+ (* GRID-HEIGHT GRID-ELEMENT-HEIGHT)
                             FONT-HEIGHT FONT-HEIGHT 5)
                WINDOW)
         (IL:PRIN1 (1+ COUNTER)
                WINDOW))
       
       ;; print the Otherwise clause

     (IL:DSPXPOSITION 5 WINDOW)
     (IL:DSPYPOSITION FONT-HEIGHT WINDOW)
     (IL:PRIN1 (CONCATENATE 'STRING "If No Match: " (WRITE-TO-STRING
                                                     OTHERWISE))
            WINDOW)
       
       ;; print the confidence heading

     (IL:DSPXPOSITION (+ GRID-LEFT-EDGE (* GRID-ELEMENT-WIDTH
                                           (1- GRID-WIDTH))
                         (ROUND (/ (- GRID-ELEMENT-WIDTH
                                      (* (IL:CHARWIDTH 87 IL:SMALLFONT)
                                         (LENGTH "Confidences")))
                                   2)))
            WINDOW)
     (IL:DSPYPOSITION (+ (* GRID-HEIGHT GRID-ELEMENT-HEIGHT)
                         FONT-HEIGHT FONT-HEIGHT 5)
            WINDOW)
     (IL:PRIN1 "Confidences" WINDOW))
    TRACE-WINDOW))
