;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-o

(in-package 'toolset)

(DEFUN TRANSFORM-INVOKE-FORMS (TREE) "transforms a form, changing the user-visible verb-concept form of invocations to INVOKE form"
   (COND
      ((SYMBOLP TREE)
       TREE)
      ((LISTP TREE)
       (if (member (car tree)
		   '(judge ask ask-user establish establish-refine
			   refine invoke))
	   (translate-invoke-form tree)
           (CONS (TRANSFORM-INVOKE-FORMS (CAR TREE))
		 (TRANSFORM-INVOKE-FORMS (CDR TREE)))))
      (T TREE)))




(defun translate-invoke-form (form)
  "Translates a user-visible invoke form to a system form"

  ;; form may look like:
  ;; (judge dragon [(arg arg arg)] [answer-type])
  ;; (ask dragon "Question" [answer-type])
  ;; (ask-user "Question" [answer-type])
  ;; (establish dragon)
  ;; (establish-refine dragon)
  ;; (refine dragon)
  ;; (invoke dragon 'verb 'arg 'arg 'arg ... 'answer-type)

  (if (not (listp form))
      (error "~S is not a list." form))
  (let ((translated-form nil))
    (setf translated-form
  (case (first form)
	(ask-user
	 (if (not (or (stringp (second form))
		      (listp (second form))))
	     (error
	      "ERROR: ~S : an ASK-USER's first argument must be a string."
	      form))
	 (case (length form)
	       (2 `(invoke *user* 'ask-user ,(second form)
			   'usual-3-val))
	       (3 `(invoke *user* 'ask-user ,(second form)
			   ',(third form)))
	       (otherwise
		(error "ERROR: specification for ASK-USER ~S does not have ~
			the correct number of arguments." form))))
	(ask
	 (if (not (or (stringp (third form))
		      ;;maybe it's a fn that will generate a string
		      ;;at runtime
		      (listp (third form))))
	     (error
	      "ERROR: ~S : an ASK form's second argument must be a string."
	      form))
	 (case (length form)
	       (3 `(invoke ,(second form) 
			   'ask
			   ,(third form) 'usual-3-val))
	       (4 `(invoke ,(second form)
			   'ask
			   ,(third form)
			   ',(fourth form)))
	       (otherwise
		(error "ERROR: specification for ASK ~S does ~
 			not have the correct number of arguments." 
		       form))))
	(judge
	 (case (length form)
	       (2 `(invoke ,(second form) 'judge))
	       (3 (if (listp (third form))
		      `(invoke ,(second form) 'judge
			       ,@(quote-list (third form)))
		    ;;judge doesn't need the result-types
		      `(invoke ,(second form) 'judge)))
	       (4 `(invoke ,(second form) 'judge
			   ,@(quote-list (third form))))
	       (otherwise
		(error "ERROR: specification for JUDGE ~S does ~
 			not have the correct number of arguments." 
		       form))))
	(establish
	 `(invoke ,(second form) 'establish))
	(establish-refine
	 `(invoke ,(second form) 'establish-refine))
	(refine 
	 `(invoke ,(second form) 'refine))
	(invoke
	 ;; leave it alone, it should be alright the way it is
	 form)))
    (return-from translate-invoke-form translated-form)))



	
		  
		
		

