;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN TRACE-A-TEST (I) "Evals a discrete pattern test with tracing."
   (DECLARE (SPECIAL *CURRENT-DRAGON*))
   (LET ((RESULT (EVAL (AREF (SLOT-VALUE *CURRENT-DRAGON* 'TESTS)
                             I))))
        (IF RESULT (TOOLSET-USER-INTERFACE::YES-TABLE-CELL 0 I)
            (TOOLSET-USER-INTERFACE::NO-TABLE-CELL 0 I))
        (RETURN-FROM TRACE-A-TEST RESULT)))


(DEFUN TRACE-THE-CONSEQUENT NIL
                            
              "Evaluates a discrete-pattern's confidence with tracing."
                            (DECLARE (SPECIAL *CURRENT-DRAGON*))
                            (LET ((RESULT (EVAL (SLOT-VALUE
                                                 *CURRENT-DRAGON*
                                                 'MATCH-CONFIDENCE))))
                                 (TOOLSET-USER-INTERFACE::STUFF-CONSEQUENT
                                  RESULT)
                                 (RETURN-FROM TRACE-THE-CONSEQUENT 
                                        RESULT)))


(DEFUN TRACED-CONSEQUENT (I) "Evaluates a confidence with tracing."
   (DECLARE (SPECIAL *CURRENT-DRAGON*))
   (LET ((RESULT (EVAL (AREF (SLOT-VALUE *CURRENT-DRAGON* '
                                    ASSOCIATED-CONFIDENCES)
                             I))))
        (TOOLSET-USER-INTERFACE::STUFF-CONSEQUENT RESULT)
        (RETURN-FROM TRACED-CONSEQUENT RESULT)))


(DEFUN TRACED-NO-MATCH NIL "Evals no-match clause with tracing."
                           (DECLARE (SPECIAL *CURRENT-DRAGON*))
                           (LET ((RESULT (EVAL (SLOT-VALUE 
                                                      *CURRENT-DRAGON*
                                                      '
                                                    NO-MATCH-CONFIDENCE
                                                      ))))
                                (TOOLSET-USER-INTERFACE::STUFF-NO-MATCH
                                 RESULT)
                                (RETURN-FROM TRACED-NO-MATCH RESULT)))


(DEFUN TRACED-TEST (I J) "Evals a match-1 test with tracing."
   (DECLARE (SPECIAL *CURRENT-DRAGON*))
   (LET ((RESULT (EVAL (AREF (SLOT-VALUE *CURRENT-DRAGON* 'TEST-BLOCK)
                             I J))))
        (IF RESULT (TOOLSET-USER-INTERFACE::YES-TABLE-CELL I J)
            (TOOLSET-USER-INTERFACE::NO-TABLE-CELL I J))
        (RETURN-FROM TRACED-TEST RESULT)))

