;;; -*- Package: Toolbed; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolbed)

(DEFCLASS DRAGON (LAIR-AGENT) (
       
       ;; system-wide unique name, eventually this will be
       ;; hidden from the tool user.

                               (UNIQUE-NAME :TYPE SYMBOL :INITARG 
					    UNIQUE-NAME)
       
       ;; name visible to the tool user

                               (DISPLAY-NAME :TYPE STRING :INITARG 
					     DISPLAY-NAME)
       
       ;; general (or regional) concept with which the dragon
       ;; is associated, and by which it can be retrieved.

                               (ASSOCIATED-CONCEPTS :TYPE LIST :INITARG
						    ASSOCIATED-CONCEPTS)
       
       ;; how the agent will respond to messages, the default
       ;; behavior for the class, in external i.e. tool-user
       ;; form

                               (DEFAULT-CONTROLLER :TYPE LIST 
                                      :ALLOCATION :CLASS)
       
       ;; specifications corresponding to source code of how 
       ;; the agent will respond to messages asking for 
       ;; problem solving to be done.  This slot will not
       ;; normally contain the system-supplied actions.

                               (CONTROL-ADDITIONS :TYPE LIST :INITARG
						  CONTROL-ADDITIONS)
       
       ;; alternative forms of the controller additions for
       ;; tracing

                               (TRACING-CONTROL-ADDITIONS :TYPE LIST :INITARG
						   TRACING-CONTROL-ADDITIONS)
       
       ;; parsed but uncompiled form of the controller,
       ;; includes tool-supplied forms.

                               (PARSED-CONTROLLER :TYPE LIST :INITARG
						  PARSED-CONTROLLER)
       
       ;; parsed but uncompiled form of the tracing controller,
       ;; including tool-supplied forms

                               (PARSED-TRACING-CONTROLLER :TYPE LIST
							  :INITARG
						  PARSED-TRACING-CONTROLLER)
       
       ;; Association list of message that the agent can
       ;; respond to, in the form of VERB, APPLYable FORM 
       ;; alternating pairs. 

                               (ACTIONS :TYPE LIST :INITARG ACTIONS)
       
       ;; the alternative forms of the responses, traced or
       ;; untraced versions, to be swapped for the versions in
       ;; actions depending on whether tracing is enabled
       ;; (indicated by the TRACE-FLAG).

                               (ALT-ACTIONS :TYPE LIST :INITARG ALT-ACTIONS)
                               (ARGUMENTS :TYPE LIST 
					  :INITARG ARGUMENTS :INITFORM NIL)
                               (COMPONENTS :TYPE LIST :INITARG COMPONENTS
					   :INITFORM NIL)

                               (COMPONENT-OF :TYPE LIST :INITARG COMPONENT-OF
					     :INITFORM NIL)

                               (CURRENT-ENGRAM :TYPE ENGRAM :INITFORM NIL)
                               (MEMORY :TYPE LIST :INITFORM NIL)
                               (MEMORY-CURRENT-SIZE :TYPE INTEGER 
                                      :INITFORM 0 :INITARG MEMORY-CURRENT-SIZE)
                               (MEMORY-RETENTION-LIMIT :TYPE INTEGER 
                                      :INITFORM 8 :INITARG 
				      MEMORY-RETENTION-LIMIT)
                               (MEMORY-RETENTION-WARNING-LIMIT :TYPE 
                                      INTEGER :INITFORM 6 :INITARG
				      MEMORY-RETENTION-WARNING-LIMIT)
			       (MONITORS :TYPE LIST :INITFORM NIL
				      :INITARG MONITORS)
                               (TOOL-USER-SLOTS :TYPE LIST :INITARG
						TOOL-USER-SLOTS)
                               (AFTERWARDS :TYPE LIST
					   :INITARG AFTERWARDS
					   :INITFORM NIL)
                               (SPECIFIC-FUNCTION :TYPE STRING :INITARG
						  SPECIFIC-FUNCTION)
                               (RATIONALE :TYPE STRING :INITARG RATIONALE)
                               (DISCLAIMER :TYPE STRING :INITARG DISCLAIMER)
                               (EXPERT :TYPE STRING :INITARG EXPERT)
                               (CITATIONS :TYPE STRING :INITARG CITATIONS)
                               (OTHER-KNOWLEDGE-SOURCES :TYPE STRING
							:INITARG
						    OTHER-KNOWLEDGE-SOURCES)
                               (HYPERTEXT-LINK :TYPE T)
                               (AUTHOR :TYPE STRING :INITARG AUTHOR)
                               (CREATION-DATE :TYPE STRING :INITARG 
					      CREATION-DATE)
                               (LAST-MODIFICATION-DATE :TYPE STRING 
						       :INITARG 
						       LAST-MODIFICATION-DATE)
       
       ;; NIL for this means that tracing is toggled OFF:

                               (TRACE-FLAG :TYPE SYMBOL :INITARG TRACE-FLAG
					   :INITFORM NIL)

                               (TRACE-WINDOW :TYPE T)
       
       ;; NIL for this means that this agent can be removed
       ;; from the system-wide ToDo list.

                               (TODO-FLAG :TYPE SYMBOL :INITARG TODO-FLAG
					  :INITFORM NIL)))


