;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMETHOD DISPLAY ((ENGRAM TOOLBED::ENGRAM)
                    &OPTIONAL PRINT-SPEC)
   (LET
    ((NAME (SLOT-VALUE (SLOT-VALUE ENGRAM 'TOOLBED::WHOSE-MEMORY?)
                  'DISPLAY-NAME))
     (TEMP NIL))
       
       ;; this method prints out  either a single action record
       ;; or all action  records of the Engram passed to it. 
       ;; Print-spec specifies which single action record to
       ;; display, or if all action records should be displayed

    (FORMAT *TRACE-OUTPUT* "~% ~%")
    (FORMAT *TRACE-OUTPUT* "~% Engram of the Dragon ~A" NAME)
    (FORMAT *TRACE-OUTPUT* "~%")
    (IF
     (OR (NOT PRINT-SPEC)
         (EQUAL PRINT-SPEC 'ALL))
     (DO
      ((NEXT (SLOT-VALUE ENGRAM 'TOOLBED::FIRST-ACTION-RECORD)))
      ;; FIRST-ACTION-RECORD initform'ed to NIL in defclass
      ((NULL NEXT) 
       NIL)
       
       ;; Print out all action-records

      (IF (NOT (slot-empty-p next 'toolbed::body))
          (FORMAT *TRACE-OUTPUT* "~% ~A" (SLOT-VALUE NEXT '
                                                TOOLBED::BODY)))
       
       ;; if next record is a transaction-record, display
       ;; invoked dragon info and return value

      (IF (TYPEP NEXT 'TOOLBED::TRANSACTION-RECORD)
          (IF (AND (NOT (slot-empty-p next 'toolbed::contactee))
                   (NOT (EQUAL (SLOT-VALUE NEXT 'TOOLBED::CONTACTEE)
                               'DESTROYED)))
              (PROGN (FORMAT *TRACE-OUTPUT* "~A from the "
                            (SLOT-VALUE NEXT 'TOOLBED::FINAL-JUDGEMENT))
       
       ;; if consultation-record then print user info also

                     (IF (TYPEP NEXT 'TOOLBED::CONSULTATION-RECORD)
                         (PROGN (FORMAT *TRACE-OUTPUT* 
                                       "user with the comment ~A."
                                       (SLOT-VALUE NEXT '
                                              TOOLBED::USER-COMMENT))
                                (FORMAT *TRACE-OUTPUT* 
                             "~%The dragon ~A recommended the value ~A"
                                       (EVAL (SLOT-VALUE NEXT
                                                    'TOOLBED::CONTACTEE
                                                    ))
                                       (SLOT-VALUE NEXT '
                                         TOOLBED::DRAGON-RECOMMENDATION
                                              )))
                         (FORMAT *TRACE-OUTPUT* "dragon ~A"
                                (SLOT-VALUE (EVAL (SLOT-VALUE
                                                   NEXT
                                                   'TOOLBED::CONTACTEE)
                                                  )
                                       'DISPLAY-NAME))))))
      (SETF NEXT (SLOT-VALUE NEXT 'TOOLBED::NEXT-RECORD))))
       
       ;; if print-spec specifies a single record, find it and
       ;; display appropriate info

    (IF
     (OR (EQUAL PRINT-SPEC 'FIRST)
         (EQUAL PRINT-SPEC 'LAST))
     (PROGN
      (IF (EQUAL PRINT-SPEC 'FIRST)
          (SETF TEMP (SLOT-VALUE ENGRAM 'TOOLBED::FIRST-ACTION-RECORD))
          (SETF TEMP (SLOT-VALUE ENGRAM 'TOOLBED::LAST-ACTION-RECORD)))
      (IF (NOT (slot-empty-p temp 'toolbed::body))
          (FORMAT *TRACE-OUTPUT* "~% ~A " (SLOT-VALUE TEMP '
                                                 TOOLBED::BODY)))
      (IF
       (TYPEP TEMP 'TOOLBED::TRANSACTION-RECORD)
       (IF
        (AND (NOT (slot-empty-p temp 'toolbed::contactee))
             (NOT (EQUAL (SLOT-VALUE TEMP 'TOOLBED::CONTACTEE)
                         'DESTROYED)))
        (PROGN (FORMAT *TRACE-OUTPUT* "~A from the "
                      (SLOT-VALUE TEMP 'TOOLBED::FINAL-JUDGEMENT))
               (IF (TYPEP TEMP 'TOOLBED::CONSULTATION-RECORD)
                   (PROGN (FORMAT *TRACE-OUTPUT* 
                                 "user with the comment ~A."
                                 (SLOT-VALUE TEMP '
                                        TOOLBED::USER-COMMENT))
                          (FORMAT *TRACE-OUTPUT* 
                             "~%The dragon ~A recommended the value ~A"
                                 (SLOT-VALUE (EVAL (SLOT-VALUE
                                                    TEMP
                                                    'TOOLBED::CONTACTEE
                                                    ))
                                        'DISPLAY-NAME)
                                 (SLOT-VALUE TEMP '
                                        TOOLBED::DRAGON-RECOMMENDATION)
                                 ))
                   (FORMAT *TRACE-OUTPUT* "dragon ~A"
                          (SLOT-VALUE (EVAL (SLOT-VALUE TEMP
                                                   'TOOLBED::CONTACTEE)
                                            )
                                 'DISPLAY-NAME))))))))
    (IF
     (NUMBERP PRINT-SPEC)
     (PROGN
      (IF (> PRINT-SPEC '0)
          (SETF TEMP (SLOT-VALUE ENGRAM 'TOOLBED::FIRST-ACTION-RECORD))
          )
      (IF (< PRINT-SPEC '0)
          (SETF TEMP (SLOT-VALUE ENGRAM 'TOOLBED::LAST-ACTION-RECORD)))
      (DO ((COUNTER '1 '1))
          ((EQUAL COUNTER (ABS PRINT-SPEC))
           NIL)
          (IF (< PRINT-SPEC '0)
              (SETF TEMP (SLOT-VALUE TEMP 'TOOLBED::PREVIOUS-RECORD)))
          (IF (> PRINT-SPEC '0)
              (SETF TEMP (SLOT-VALUE TEMP 'TOOLBED::NEXT-RECORD)))
          (SETF COUNTER (1+ COUNTER)))
      (IF (NOT (slot-empty-p temp 'toolbed::body))
          (FORMAT *TRACE-OUTPUT* "~% ~A " (SLOT-VALUE TEMP '
                                                 TOOLBED::BODY)))
      (IF
       (TYPEP TEMP 'TOOLBED::TRANSACTION-RECORD)
       (IF
        (AND (NOT (slot-empty-p temp 'toolbed::contactee))
             (NOT (EQUAL (SLOT-VALUE TEMP 'TOOLBED::CONTACTEE)
                         'DESTROYED)))
        (PROGN (FORMAT *TRACE-OUTPUT* "~A from the "
                      (SLOT-VALUE TEMP 'TOOLBED::FINAL-JUDGEMENT))
               (IF (TYPEP TEMP 'TOOLBED::CONSULTATION-RECORD)
                   (PROGN (FORMAT *TRACE-OUTPUT* 
                                 "user with the comment ~A."
                                 (SLOT-VALUE TEMP '
                                        TOOLBED::USER-COMMENT))
                          (FORMAT *TRACE-OUTPUT* 
                             "~%The dragon ~A recommended the value ~A"
                                 (SLOT-VALUE (EVAL (SLOT-VALUE
                                                    TEMP
                                                    'TOOLBED::CONTACTEE
                                                    ))
                                        'DISPLAY-NAME)
                                 (SLOT-VALUE TEMP '
                                        TOOLBED::DRAGON-RECOMMENDATION)
                                 ))
                   (FORMAT *TRACE-OUTPUT* "dragon ~A"
                          (SLOT-VALUE (EVAL (SLOT-VALUE TEMP
                                                   'TOOLBED::CONTACTEE)
                                            )
                                 'DISPLAY-NAME))))))))
    (FORMAT *TRACE-OUTPUT* "~%  Display complete.")))

