;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)



(defmethod CONTROLLERS ((C-INSTANCE classifier)) 
  (return-from
   controllers
   (acons
    'stipulate
    `(lambda
       (drags &optional (case *current-case*) result-type)
       (declare (special *current-dragon* *current-case*)
		(ignore result-type))
       (let ((drag-list (if (not (listp drags))
			   (list drags) drags)))
       (labels
	((stip-drags-and-parents (dragons)
	  (if (not (null dragons))
	      (let (current-drag)
		(dolist (drag dragons)
			(setf current-drag (eval drag))
			(if (not (eq (get-case drag) case))
			    (progn
			      (new-case current-drag)
			      (setf (slot-value current-drag 'case) case)))
			(if (not (eq (get-status drag case) 'established))
			    (progn
			      (setf (slot-value current-drag 'status) 
				    'established)
			      (if (get-supers 
				   (slot-value current-drag 'unique-name)
				   *current-dragon*)
				  (if (or
				       (eq 
					(slot-value 
					 current-drag 'parent-join) 'and)
				       (= (length (get-supers
						   (slot-value
						    current-drag 'unique-name)
						   *current-dragon*)) 1))
				      (stip-drags-and-parents 
				       (get-supers (slot-value
						    current-drag 'unique-name)
						   *current-dragon*)))))))))))
	
	(dolist (adrag drag-list)
		(stip-drags-and-parents (get-supers adrag *current-dragon*)))
	t)))

    (acons 
     'tell-me-about
     `(lambda
	(dragons &optional (case *current-case*) result-type)
	(declare (special *current-dragon* *current-case*)
		 (ignore result-type))
	(let ((results nil) 
	      (drag-list (if (not (listp dragons))
			     (list dragons)
			     dragons))
	      eval-drag temp-case)
	  (dolist (drag drag-list)
		  (setf eval-drag (eval drag))
		  (if (and (equal (get-case drag) case)
			   (not (eq (get-status drag case) 'not-run)))
		      (setf 
		       results 
		       (cons
			(list 
			 (slot-value eval-drag 'unique-name)
			 ;;should be able to return
			 ;; both confidence result of
			 ;;establish & result of refine
			 ;;if refine result is not-done,
			 ;;invoke with refine
			 (get-last-result drag case)
			 (if (get-refine-result drag case)
			     (get-refine-result drag case)
			     (if (get-context drag :case case)
				 (progn
				   (setf temp-case *current-case*)
				   (setf *current-case* case)
				   (invoke eval-drag 'refine)
				   (setf *current-case* temp-case)
				   (get-refine-result eval-drag case))
			         nil))
			 ;; do status last -- refine can 
			 ;; change status if
			 ;; subs are exhaustive
			 (get-status drag case))
			results))
		      (setf results
			    (cons
			     (append
			      (list (slot-value eval-drag 'unique-name))
			      (progn
				(setf temp-case *current-case*)
				(setf *current-case* case)
				(invoke eval-drag 'establish-refine)
				(setf *current-case* temp-case)
				(list
				 (get-last-result drag case)
				 (get-refine-result drag case)
				 (get-status drag case))))
			     results))))
	  results))
     nil))))



(defun get-context
  (drag &optional &key (case *current-case*) result-type (context-type nil))
  (declare (special *current-case*) (ignore result-type))
	
  (labels
   ((check-and-parents 
     (dragons case context-type)

     (if (null dragons) (return-from check-and-parents 'got-context))
     (if (eq context-type 'none)
	 (progn
	   (format *trace-output*
		   "Get-context: Check-and-parents: asked to check parents ~S ~
		 with context type of NONE.~%" dragons)
	   ;; none needs no context, so has context regardless of parental
	   ;; situation.
	   (return-from check-and-parents 'got-context)))

     (let (eval-drag temp-case (context 'got-context))
       ;; start out with context set to got-context, drop it down
       ;; to the worst case seen so far (ruled-out or no-context)
       ;; when it is seen (since this is an and-join, it only takes
       ;; one parent below the status necessary for context 
       ;; to prevent context)

       (do ((drag (pop dragons) (pop dragons)))
	   ((null drag))
	   (if (typep drag 'symbol) (setf eval-drag (eval drag))
	     (setf eval-drag drag))
	   (if (or (not (equal (get-case drag) case))
		   (eq (get-status drag case) 'not-run))

	       ;; hasn't run in this case, so invoke it with establish,
	       ;; which will force it to check context, and set its
	       ;; status

	       (progn
		 ;; attempt to establish it
		 (setf temp-case *current-case*)
		 (setf *current-case* case)
		 (invoke eval-drag 'establish)
		 (setf *current-case* temp-case)))

	   ;; okay, this parent has now definitely run in this case. 
	   ;; Set context value on the basis of parent's status.

	   (case (get-status drag case) 
		 (ruled-out
		  ;; does refute context
		  (setf context 'ruled-out))

		 (suspended

		  ;; if type is establish, set context to no-context if
		  ;; dragon suspends (unless context is already 
		  ;; ruled-out), else context-type is suspend
		  ;; so leave context alone

		  (if (and (eq context-type 'establish)
			   (not (eq context 'ruled-out)))
		      (setf context 'no-context)))
		 (established
		  ;; leave context alone
		  ))
	   
	   ;; just in case, check to make sure exclusivity of subs does not
	   ;; prevent context

	   (if (not (equal context 'ruled-out))
	       (if (member 'exclusive (slot-value eval-drag 'child-join))
		   (if (other-sub-established eval-drag case)
		       (progn 
			 ;; rule out this sub
			 (setf context 'ruled-out)
			 ;; rule out its siblings, except the established one
			 (rule-out-unestablished-subs eval-drag case)
			 )))))

       ;; return context
       context))

    (check-or-parents 
     (dragons case context-type)

     (if (null dragons) (return-from check-or-parents 'got-context))
     (if (eq context-type 'none)
	 (progn
	   (format *trace-output*
		   "Get-context: Check-or-parents: asked to check parents ~S ~
		 with context type of NONE.~%" dragons)
	   ;; none needs no context, so has context regardless of parental
	   ;; situation.
	   (return-from check-or-parents 'got-context)))


     (let (eval-drag temp-case (context 'ruled-out)
		     (number-of-parents (length dragons)))
       ;; assume worst case of ruled-out, raise it up to best case
       ;; seen so far (only need one dragon of the right value to
       ;; raise to no-context or got-context)

       (do ((drag (pop dragons) (pop dragons)))
	   ;; only have to go until we get context -- we can't
	   ;; get any better, and with or-join, once we've gotten
	   ;; here the value won't change
	   ((or (eq context 'got-context) (null drag)))
	   
	   (if (typep drag 'symbol) (setf eval-drag (eval drag))
	     (setf eval-drag drag))
	   (if (or (not (equal (get-case drag) case))
		   (eq (get-status drag case) 'not-run))

	       ;; hasn't run in this case, so invoke it with establish,
	       ;; which will force it to check context, and set its
	       ;; status

	       (progn
		 ;; attempt to establish it
		 (setf temp-case *current-case*)
		 (setf *current-case* case)
		 (invoke eval-drag 'establish)
		 (setf *current-case* temp-case)))

	   ;; okay, this parent has definitely run in this case. 
	   ;; Set context value on the basis of parent's status.

	   (case (get-status drag case)
		 (ruled-out
		  ;; leave context alone (we assume we start out
		  ;; with ruled-out, keep skipping over ruled-outs
		  ;; till we find something that can change our value)
		  )
		 (suspended
		  ;; if context-type is establish, set context to no-context
		  ;; unless it is already get-context
		  (if (and (eq context-type 'establish)
			   (not (eq context 'got-context)))
		      (setf context 'no-context))
		  ;; if context-type is suspend, set context to got-context
		  (if (eq context-type 'suspend)
		      (setf context 'got-context)))
		 (established
		  ;; gives context, regardless of context-type
		  (setf context 'got-context)))

	   ;; just in case, check to make sure exclusivity of subs does not
	   ;; prevent context

	   ;; since this is an or-join, if there are multiple parents, 
	   ;; exclusivity is undefined. If there is only one parent, 
	   ;; treat as usual for exclusive subs.

	   (if (member 'exclusive (slot-value eval-drag 'child-join))
		 (if (> number-of-parents 1)
		     (format *trace-output*
			     "Warning: context check of child with multiple or-joined ~
				 parents shows parent ~S has exclusive child-join." 
			     (slot-value eval-drag 'unique-name))
		     (if (other-sub-established eval-drag case)
			 (progn
			   ;; rule out this sub
			   (setf context 'ruled-out)
			   ;; rule out its siblings, except the established one
			   (rule-out-unestablished-subs eval-drag case))))))
      
       ;; return context
       context))

    (other-sub-established 
     (eval-drag case)
     (dolist (sub (get-subs (slot-value eval-drag 'unique-name)
			    (eval (slot-value eval-drag 'classifier))))
	     (if (equal (get-status sub case) 'established)
		 (return-from other-sub-established t)))
     (return-from other-sub-established nil))

    (rule-out-unestablished-subs 
     (eval-drag case &aux (established nil))
     (dolist (sub (get-subs (slot-value eval-drag 'unique-name)
			    (eval (slot-value eval-drag 'classifier))))
	     (if (equal (get-status sub case) 'established)
		 (setf established (cons sub established))
	         (progn
		   (setf (slot-value (eval sub) 'status) 'ruled-out)
		   (setf (slot-value (eval sub) 'case) case))))
     (case (length established)
	   (1 ;; everything's fine
	    nil)
	   (0 ;; error -- should have been one established sub
	    (format *trace-output*
		    "In RULE-OUT-UNESTABLISHED-SUBS in GET-CONTEXT:~%
dragon ~S has exclusive subs, one of which was established, but when we
went to rule out the others, no subs were established..."
		    (slot-value eval-drag 'unique-name)))
	   (otherwise ;; error -- too many established subs
	    (format *trace-output*
		    "In RULE-OUT-UNESTABLISHED-SUBS in GET-CONTEXT:~%
dragon ~S has exclusive subs, one of which was established, but when we
went to rule out the others, several subs were established: ~S.~%"
		    (slot-value eval-drag 'unique-name) established)))))

   (let (eval-drag)
     (if (typep drag 'symbol) (setf eval-drag (eval drag))
       (setf eval-drag drag))
     (if (null context-type) 
	 (setf context-type (slot-value eval-drag 'context-type)))
     (if (eq context-type 'none)
	 (progn
	   (format *trace-output*
		   "Get-context: asked to check dragon ~S ~
		 with context type of NONE.~%" 
		   (slot-value eval-drag 'unique-name))
	   ;; none needs no context, so has context regardless of parental
	   ;; situation.
	   (return-from get-context 'got-context)))

     (return-from get-context
		  (if (eq (slot-value eval-drag 'parent-join) 'and)
		      (check-and-parents 
		       (get-supers (slot-value
				    eval-drag 'unique-name)
				   (eval 
				    (slot-value eval-drag 'classifier)))
		       case context-type)
		      (check-or-parents
		       (get-supers (slot-value
				    eval-drag
				    'unique-name)
				   (eval
				    (slot-value eval-drag 'classifier)))
		       case context-type))))))












