;; -*- Lisp -*-

;;;; Test code for ATRE Blocksworld system

;; Copyright (c) 1986, 1987, 1988, 1989, 1990 Kenneth D. Forbus, 
;;   Northwestern University, and Johan de Kleer, Xerox Corporation.  
;; All rights reserved.

(in-package 'user)

(defvar *blocks-file*
  #+(:AND :KDF :UNIX)
  "/u/bps/code/atms/blocks.lisp"
  )

(setq *choice-set-finder* 'make-blocks-choice-sets)

(defun restart (&optional (debugging nil))
  (setq *atre* (create-atre "Blocks ATRE" :debugging debugging))
  (load *blocks-file*))

(defun build-blocks (block-list)
  (dolist (block block-list)
    (assert! `(block ,block) 'Definition)))

(defun blocks3 (&optional (*debug-plan-a* nil) (debugging nil))
  (format t "~%Building fresh ATRE.") 
  (restart debugging)
  (format t "~%Building three blocks")
  (build-blocks '(A B C))
  (format t "~%Envisioning..")
  (envision *atre*))

(defun blocks4 (&optional (*debug-plan-a* nil) (debugging nil))
  (restart debugging)
  (build-blocks '(A B C D))
  (envision *atre*))

;;;; Finding choice sets

(proclaim '(special *choice-sets*)) 

(defun gather-blocks () (mapcar #'cadr (fetch `(block ?x))))

(defun make-blocks-choice-sets ()
  (let ((blocks (gather-blocks)))
    (setq *choice-sets* nil)
    (dolist (block blocks)
	    ;; First type of choice set determines
	    ;; what the block can be on.
      (push `((Holding ,block) (On ,block Table)
	      ,@ (mapcar #'(lambda (other)
			     `(On ,block ,other))
			 (remove block blocks)))
	    *choice-sets*)
      ;;; Next consider what can be on the block
      (push `((Holding ,block) (Clear ,block)
	      ,@ (mapcar #'(lambda (other)
			     `(ON ,other ,block))
			 (remove block blocks)))
	    *choice-sets*))
    (push `((HAND-EMPTY)
	    ,@ (mapcar #'(lambda (block)
			   `(HOLDING ,block)) blocks))
	  *choice-sets*)))
