;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: (TMS Lisp 1000); Base: 10. -*-

"(c) Copyright 1986 Xerox Corporation.  All rights reserved.  Subject to
the following conditions, permission is granted to use and copy this
software and to prepare derivative works:  Such use, copying or
preparation of derivative works must be for non-commercial research or
educational purposes; each copy or derivative work must include this
copyright notice in full; a copy of each completed derivative work must
be returned to:  DEKLEER@XEROX.COM (Arpanet) or Johan de Kleer,
Xerox PARC, 3333 Coyote Hill Road, Palo Alto, CA 94304.  This software
is made available AS IS, and Xerox Corporation makes no warranty about
the software or its performance."

;;; The Assumption-Based TMS

;(in-package 'tms)

(defun compile-and-load-atms ()
  (compile-file "walk.lisp")
  (load "walk")
  (compile-file "defs.lisp")
  (load "defs")
  (compile-file "user.lisp")
  (load "user")
  (compile-file "replay.lisp")
  (load "replay")
  (compile-file "vector.lisp")
  (load "vector")
  (compile-file "blists.lisp")			; You can live without this.
  (load "blists")
  (compile-file "batms3.lisp")
  (load "batms3")
  (compile-file "hash.lisp")
  (load "hash")
  (compile-file "tms7.lisp")
  (load "tms7")
  (compile-file "interp.lisp")
  (load "interp")
  (compile-file "cons3.lisp")
  (load "cons3")
  (compile-file "nml.lisp")
  (load "nml")
  (compile-file "tree.lisp")
  (load "tree")
  (compile-file "label.lisp")
  (load "label")
  (compile-file "breadth.lisp")			; You can live without this.
  (load "breadth")
  (compile-file "allocate.lisp")
  (load "allocate")
  (compile-file "blots.lisp")			; You can live without this.
  (load "blots")
  (compile-file "blits.lisp")			; You can live without this.
  (load "blits")
  (compile-file "examples.lisp")
  (load "examples")
  (compile-file "diags.lisp")
  (load "diags")
)

(defun load-atms ()
  (load "walk")
  (load "defs")
  (load "user")
  (load "replay")
  (load "vector")
  (load "blists")
  (load "batms3")
  (load "hash")
  (load "tms7")
  (load "interp")
  (load "cons3")
  (load "nml")
  (load "tree")
  (load "label")
  (load "breadth")
  (load "allocate")
  (load "blots")
  (load "blits")
  (load "examples")
  (load "diags")
)

