(predicate  :name    air)

(term       :name    abnormal)

(term :name         (air abnormal)
      :remindings   ()
      :relations    (((((bone normal) and (air abnormal))  requires conductive_HL) "ee" NIL)
                     (((air abnormal)  hasTypicalGen (air mild)) "ee" NIL)
                     (((air abnormal)  hasTypicalGen (air moderate)) "ee" NIL)))

(term       :name    mild)

(term :name         (air mild)
      :remindings   ((acoustic_neuroma 0.25)
                     ((discontinuity ossicular_chain) 0.25)
                     (meniere_s 0.25))
      :relations    ((((air mild)  requires acoustic_neuroma) "ee" NIL)
                     (((air mild)  hasTypicalSpec (air abnormal)) "ee" NIL)
                     ((((air mild) and (bone normal)) sometimes defimplies conductive_HL) "ee" NIL)))

(term       :name    moderate)

(term :name         (air moderate)
      :remindings   ((meniere_s 0.25))
      :relations    ((((air moderate)  requires meniere_s) "ee" NIL)
                     (((air moderate)  hasTypicalSpec (air abnormal)) "ee" NIL)))

(term       :name    normal)

(term :name         (air normal)
      :remindings   ((normal_ear 0.5))
      :relations    ((((air normal)  requires facial_nerve_disorder) "ee" NIL)
                     (((air normal)  requires normal_ear) "ee" NIL)))

(term       :name    severe)

(term :name         (air severe)
      :remindings   ((malleus_fixation 0.25))
      :relations    ((((air severe) sometimes cooccurs with malleus_fixation) "ee" NIL)))

(predicate  :name    bone)

(term       :name    mild)

(term :name         (bone mild)
      :remindings   ((acoustic_neuroma 0.25))
      :relations    ((((bone mild)  requires acoustic_neuroma) "ee" NIL)))

(term       :name    normal)

(term :name         (bone normal)
      :remindings   ((conductive_HL 0.25)
                     (normal_ear 0.25))
      :relations    ((((bone normal)  cooccurs with conductive_HL) "ee" NIL)
                     (((bone normal) usually is required by (ipsi_AR normal)) "ee" NIL)
                     (((bone normal)  requires normal_ear) "ee" NIL)
                     ((((bone normal) and (air abnormal))  requires conductive_HL) "ee" NIL)
                     ((((air mild) and (bone normal)) sometimes defimplies conductive_HL) "ee" NIL)))

(predicate  :name    contra_AR)

(term       :name    abnormal)

(term :name         (contra_AR abnormal)
      :remindings   ()
      :relations    ((((contra_AR abnormal)  hasTypicalGen (contra_AR elevated)) "ee" NIL)
                     (((contra_AR abnormal)  hasTypicalGen (contra_AR absent)) "ee" NIL)))

(term       :name    absent)

(term :name         (contra_AR absent)
      :remindings   ((acoustic_neuroma 0.25)
                     (otitis_media 0.25))
      :relations    ((((contra_AR absent)  hasTypicalSpec (contra_AR abnormal)) "ee" NIL)
                     (((contra_AR absent) sometimes cooccurs with conductive_HL) "ee" NIL)
                     (((contra_AR absent)  requires conductive_HL) "ee" NIL)))

(term       :name    elevated)

(term :name         (contra_AR elevated)
      :remindings   ((acoustic_neuroma 0.25))
      :relations    ((((contra_AR elevated)  hasTypicalSpec (contra_AR abnormal)) "ee" NIL)
                     (((contra_AR elevated)  requires acoustic_neuroma) "ee" NIL)))

(term       :name    normal)

(term :name         (contra_AR normal)
      :remindings   ((facial_nerve_disorder 0.25)
                     (normal_ear 0.25))
      :relations    (((((other_c_AR absent) and (ipsi_AR absent) and (contra_AR normal) and (other_i_AR normal))  requires facial_nerve_disorder) "ee" NIL)
                     (((contra_AR normal)  requires normal_ear) "ee" NIL)))

(predicate  :name    ipsi)

(term       :name    absent)

(term :name         (ipsi absent)
      :remindings   ()
      :relations    ((((ipsi absent)  equivalent (ipsi_AR absent)) "ee" NIL)))

(predicate  :name    ipsi_AR)

(term       :name    abnormal)

(term :name         (ipsi_AR abnormal)
      :remindings   ()
      :relations    ((((ipsi_AR abnormal)  hasTypicalGen (ipsi_AR elevated)) "ee" NIL)
                     (((ipsi_AR abnormal)  hasTypicalGen (ipsi_AR absent)) "ee" NIL)))

(term       :name    absent)

(term :name         (ipsi_AR absent)
      :remindings   ((otitis_media 0.25))
      :relations    (((((other_c_AR absent) and (ipsi_AR absent) and (contra_AR normal) and (other_i_AR normal))  requires facial_nerve_disorder) "ee" NIL)
                     (((ipsi_AR absent)  hasTypicalSpec (ipsi_AR abnormal)) "ee" NIL)
                     (((ipsi_AR absent)  cooccurs with conductive_HL) "ee" NIL)
                     (((ipsi_AR absent)  requires otitis_media) "ee" NIL)
                     (((ipsi_AR absent)  equivalent (ipsi absent)) "ee" NIL)
                     (((ipsi_AR absent)  requires (discontinuity ossicular_chain)) "ee" NIL)))

(term       :name    elevated)

(term :name         (ipsi_AR elevated)
      :remindings   ((meniere_s 0.25)
                     (acoustic_neuroma 0.25))
      :relations    ((((ipsi_AR elevated)  requires meniere_s) "ee" NIL)
                     (((ipsi_AR elevated)  hasTypicalSpec (ipsi_AR abnormal)) "ee" NIL)
                     (((ipsi_AR elevated)  requires acoustic_neuroma) "ee" NIL)))

(term       :name    normal)

(term :name         (ipsi_AR normal)
      :remindings   ((normal_ear 0.25))
      :relations    ((((ipsi_AR normal)  requires (bone normal)) "ee" NIL)
                     (((ipsi_AR normal)  requires normal_ear) "ee" NIL)))

(predicate  :name    other_c_AR)

(term       :name    abnormal)

(term :name         (other_c_AR abnormal)
      :remindings   ()
      :relations    ((((other_c_AR abnormal)  hasTypicalGen (other_c_AR absent)) "ee" NIL)
                     (((other_c_AR abnormal)  hasTypicalGen (other_c_AR elevated)) "ee" NIL)))

(term       :name    absent)

(term :name         (other_c_AR absent)
      :remindings   ((acoustic_neuroma 0.25)
                     (conductive_HL 0.25)
                     (facial_nerve_disorder 0.5)
                     (otitis_media 0.25))
      :relations    (((((other_c_AR absent) and (ipsi_AR absent) and (contra_AR normal) and (other_i_AR normal))  requires facial_nerve_disorder) "ee" NIL)
                     (((other_c_AR absent)  cooccurs with conductive_HL) "ee" NIL)
                     (((other_c_AR absent)  hasTypicalSpec (other_c_AR abnormal)) "ee" NIL)
                     (((other_c_AR absent)  requires prob_in_Case_6_2_L) "ee" NIL)))

(term       :name    elevated)

(term :name         (other_c_AR elevated)
      :remindings   (((discontinuity ossicular_chain) 0.25))
      :relations    ((((other_c_AR elevated)  requires (discontinuity ossicular_chain)) "ee" NIL)
                     (((other_c_AR elevated)  hasTypicalSpec (other_c_AR abnormal)) "ee" NIL)))

(term       :name    normal)

(term :name         (other_c_AR normal)
      :remindings   ((normal_ear 0.25))
      :relations    ((((other_c_AR normal)  requires normal_ear) "ee" NIL)))

(predicate  :name    other_i_AR)

(term       :name    abseent)

(term :name         (other_i_AR abseent)
      :remindings   ()
      :relations    ())

(term       :name    absent)

(term :name         (other_i_AR absent)
      :remindings   ()
      :relations    ())

(term       :name    elevated)

(term :name         (other_i_AR elevated)
      :remindings   ()
      :relations    ())

(term       :name    normal)

(term :name         (other_i_AR normal)
      :remindings   ((facial_nerve_disorder 0.25)
                     (normal_ear 0.25))
      :relations    (((((other_c_AR absent) and (ipsi_AR absent) and (contra_AR normal) and (other_i_AR normal))  requires facial_nerve_disorder) "ee" NIL)
                     (((other_i_AR normal)  requires normal_ear) "ee" NIL)))

(predicate  :name    otoscopy)

(term       :name    normal)

(term :name         (otoscopy normal)
      :remindings   ((malleus_fixation 0.5))
      :relations    ((((otoscopy normal)  cooccurs with malleus_fixation) "ee" NIL)))

(predicate  :name    slope_toward)

(term       :name    low)

(term :name         (slope_toward low)
      :remindings   ((meniere_s 0.5))
      :relations    ((((slope_toward low) usually cooccurs with meniere_s) "ee" NIL)))

(predicate  :name    speech_intell)

(term       :name    abnormal)

(term :name         (speech_intell abnormal)
      :remindings   ()
      :relations    ((((speech_intell abnormal)  requires sensorineural) "ee" NIL)
                     (((speech_intell abnormal)  hasTypicalGen (speech_intell moderate)) "ee" NIL)))

(term       :name    mild)

(term :name         (speech_intell mild)
      :remindings   ((meniere_s 0.25))
      :relations    ((((speech_intell mild)  causes meniere_s) "ee" NIL)))

(term       :name    moderate)

(term :name         (speech_intell moderate)
      :remindings   ((sensorineural 0.5))
      :relations    ((((speech_intell moderate)  hasTypicalSpec (speech_intell abnormal)) "ee" NIL)
                     (((speech_intell moderate)  requires sensorineural) "ee" NIL)))

(term       :name    normal)

(term :name         (speech_intell normal)
      :remindings   (((discontinuity ossicular_chain) 0.25)
                     (conductive_HL 0.25)
                     (facial_nerve_disorder 0.25)
                     (normal_ear 0.25))
      :relations    ((((speech_intell normal)  requires facial_nerve_disorder) "ee" NIL)
                     (((speech_intell normal)  requires normal_ear) "ee" NIL)
                     (((speech_intell normal)  requires not_sensorineural_HL) "ee" NIL)
                     (((speech_intell normal)  requires prob_not_sensorineural) "ee" NIL)))

(term       :name    rollover)

(term :name         (speech_intell rollover)
      :remindings   ((acoustic_neuroma 1.0))
      :relations    ((((speech_intell rollover) usually cooccurs with acoustic_neuroma) "ee" NIL)))

(predicate  :name    tymp_peak)

(term       :name    compliant)

(term :name         (tymp_peak compliant)
      :remindings   (((discontinuity ossicular_chain) 1.0))
      :relations    ((((tymp_peak compliant) strongly cooccurs with (discontinuity ossicular_chain)) "ee" NIL)))

(term       :name    flat)

(term :name         (tymp_peak flat)
      :remindings   ((malleus_fixation 1.0)
                     (conductive_HL 0.5))
      :relations    ((((tymp_peak flat)  cooccurs with malleus_fixation) "ee" NIL)
                     (((tymp_peak flat)  cooccurs with (tymp_pr unknown)) "ee" NIL)
                     (((tymp_peak flat)  hasFunction non_compliant_middle_ear) "ee" NIL)))

(term       :name    normal)

(term :name         (tymp_peak normal)
      :remindings   ((normal_ear 0.25))
      :relations    ((((tymp_peak normal)  requires normal_ear) "ee" NIL)))

(predicate  :name    tymp_pr)

(term       :name    negative)

(term :name         (tymp_pr negative)
      :remindings   ((otitis_media 0.5))
      :relations    ((((tymp_pr negative)  requires otitis_media) "ee" NIL)))

(term       :name    normal)

(term :name         (tymp_pr normal)
      :remindings   ((normal_ear 0.25))
      :relations    ((((tymp_pr normal)  requires normal_ear) "ee" NIL)
                     (((tymp_pr normal)  requires not_effusion) "ee" NIL)))

(term       :name    unknown)

(term :name         (tymp_pr unknown)
      :remindings   ()
      :relations    ((((tymp_pr unknown)  cooccurs with (tymp_peak flat)) "ee" NIL)))

(term :name         cochlear
      :remindings   ()
      :relations    (((cochlear  hasTypicalGen meniere_s) "ee" NIL)
                     ((cochlear  hasTypicalSpec sensorineural) "ee" NIL)))

(term :name         conductive_HL
      :remindings   ()
      :relations    (((conductive_HL  cooccurs with (bone normal)) "ee" NIL)
                     ((conductive_HL sometimes cooccurs with (contra_AR absent)) "ee" NIL)
                     ((conductive_HL  cooccurs with (ipsi_AR absent)) "ee" NIL)
                     ((conductive_HL  cooccurs with (other_c_AR absent)) "ee" NIL)
                     ((conductive_HL  hasTypicalGen malleus_fixation) "ee" NIL)
                     ((conductive_HL sometimes is required by fullness) "ee" NIL)
                     ((conductive_HL moderately is required by ((bone normal) and (air abnormal))) "ee" NIL)
                     ((conductive_HL  hasTypicalGen (discontinuity ossicular_chain)) "ee" NIL)
                     ((conductive_HL  hasTypicalGen otitis_media) "ee" NIL)
                     ((conductive_HL occasionally is required by (contra_AR absent)) "ee" NIL)
                     ((conductive_HL  defimplies ((air mild) and (bone normal))) "ee" NIL)))

(term :name         decay_AR
      :remindings   ((acoustic_neuroma 0.5))
      :relations    (((decay_AR moderately cooccurs with acoustic_neuroma) "ee" NIL)))

(term :name         decay_tone
      :remindings   ((acoustic_neuroma 1.0))
      :relations    (((decay_tone strongly cooccurs with acoustic_neuroma) "ee" NIL)))

(term :name         facial_nerve_weakness
      :remindings   ((facial_nerve_disorder 0.25)
                     (acoustic_neuroma 0.25))
      :relations    (((facial_nerve_weakness  requires acoustic_neuroma) "ee" NIL)))

(term :name         facial_paralysis
      :remindings   ((facial_nerve_disorder 1.0))
      :relations    (((facial_paralysis sometimes cooccurs with facial_nerve_disorder) "ee" NIL)))

(term :name         fullness
      :remindings   ((acoustic_neuroma 0.25)
                     (meniere_s 0.25))
      :relations    (((fullness  requires acoustic_neuroma) "ee" NIL)
                     ((fullness  requires conductive_HL) "ee" NIL)
                     ((fullness  requires meniere_s) "ee" NIL)))

(term :name         nausea
      :remindings   ((meniere_s 0.5))
      :relations    (((nausea  requires meniere_s) "ee" NIL)))

(term :name         noise_exposure
      :remindings   ((noise_induced 1.0))
      :relations    (((noise_exposure sometimes defimplies noise_induced) "ee" NIL)))

(term :name         non_compliant_middle_ear
      :remindings   ()
      :relations    (((non_compliant_middle_ear  isFunctionOf (tymp_peak flat)) "ee" NIL)))

(term :name         not_effusion
      :remindings   ()
      :relations    (((not_effusion sometimes is required by (tymp_pr normal)) "ee" NIL)))

(term :name         not_sensorineural_HL
      :remindings   ()
      :relations    (((not_sensorineural_HL moderately is required by (speech_intell normal)) "ee" NIL)))

(term :name         notch_4k
      :remindings   ((noise_induced 0.5))
      :relations    (((notch_4k sometimes cooccurs with noise_induced) "ee" NIL)))

(term :name         prob_in_Case_6_2_L
      :remindings   ()
      :relations    (((prob_in_Case_6_2_L probably is required by (other_c_AR absent)) "ee" NIL)))

(term :name         prob_not_sensorineural
      :remindings   ()
      :relations    (((prob_not_sensorineural strongly is required by (speech_intell normal)) "ee" NIL)))

(term :name         sensorineural
      :remindings   ()
      :relations    (((sensorineural  hasTypicalGen cochlear) "ee" NIL)
                     ((sensorineural usually is required by (speech_intell abnormal)) "ee" NIL)
                     ((sensorineural usually is required by (speech_intell moderate)) "ee" NIL)))

(term :name         speech_distorted
      :remindings   ((meniere_s 0.5))
      :relations    (((speech_distorted  causes meniere_s) "ee" NIL)))

(term :name         tinnitus
      :remindings   ((noise_induced 0.5)
                     (acoustic_neuroma 0.25)
                     (meniere_s 0.5))
      :relations    (((tinnitus usually cooccurs with noise_induced) "ee" NIL)
                     ((tinnitus occasionally cooccurs with acoustic_neuroma) "ee" NIL)
                     ((tinnitus  requires meniere_s) "ee" NIL)))

(term :name         vertigo
      :remindings   ((meniere_s 0.5))
      :relations    (((vertigo  requires meniere_s) "ee" NIL)))

(term :name         vomiting
      :remindings   ((meniere_s 0.25))
      :relations    (((vomiting  requires meniere_s) "ee" NIL)))

(term :name         case_13_1
      :category     malleus_fixation
      :features     ((air severe) (other_i_AR normal) (bone normal) (speech_intell normal) (tymp_peak flat) (tymp_pr negative) (contra_AR absent)
                     (ipsi_AR absent) (other_c_AR absent) fullness)
      :typicality   1
      :differences  ( ))

(term :name         case_14_2A
      :category     meniere_s
      :features     ((air moderate) (other_c_AR normal) (ipsi_AR normal) (contra_AR normal) (other_i_AR normal) (speech_intell moderate) vertigo
                     nausea vomiting tinnitus)
      :typicality   1
      :differences  ((case_14_2H <- ( fullness))))

(term :name         case_14_2H
      :category     meniere_s
      :features     ((air moderate) (other_c_AR normal) (ipsi_AR normal) (contra_AR normal) (other_i_AR normal) (speech_intell moderate) fullness
                     tinnitus)
      :typicality   1
      :differences  ((case_14_2A <- ( vomiting nausea vertigo))))

(term :name         case_17_1_R
      :category     otitis_media
      :features     ((air abnormal) (other_i_AR absent) (bone normal) (speech_intell normal) (tymp_peak flat) (tymp_pr negative) (contra_AR absent)
                     (ipsi_AR absent) (other_c_AR absent))
      :typicality   3
      :differences  ( ))

(term :name         case_1_1
      :category     acoustic_neuroma
      :features     (facial_nerve_weakness fullness (contra_AR absent) decay_tone (other_c_AR absent) (ipsi_AR absent) (air mild)
                     (bone mild) (tymp_pr normal) (tymp_peak normal) (speech_intell rollover) (other_i_AR normal))
      :typicality   1
      :differences  ( ))

(term :name         case_1_2
      :category     acoustic_neuroma
      :features     ((contra_AR abnormal) (ipsi_AR abnormal))
      :typicality   1
      :differences  ( ))

(term :name         case_1_2_N
      :category     normal_ear
      :features     ((air normal) (bone normal) (speech_intell normal) (ipsi_AR normal) (contra_AR normal) (other_i_AR elevated) (other_c_AR elevated)
                     (tymp_pr normal) (tymp_peak normal))
      :typicality   1
      :differences  ((case_6_2_L <- ( (ipsi_AR absent) (air mild)))))

(term :name         case_1_3_m
      :category     acoustic_neuroma
      :features     ((air normal) (other_i_AR normal) (bone normal) (speech_intell rollover) (tymp_peak normal) (tymp_pr normal) (contra_AR elevated)
                     (ipsi_AR elevated) (other_c_AR normal) tinnitus decay_AR)
      :typicality   2
      :differences  ((case_NORMAL <- ( (contra_AR normal) (speech_intell normal)))))

(term :name         case_6_1_L
      :category     (discontinuity ossicular_chain)
      :features     ((air mild) (bone normal) (speech_intell normal) (contra_AR absent) (tymp_peak compliant) (tymp_pr normal) (ipsi_AR absent)
                     (other_i_AR normal) (other_c_AR elevated))
      :typicality   1
      :differences  ( ))

(term :name         case_6_2_L
      :category     (discontinuity ossicular_chain)
      :features     ((other_c_AR abnormal) (air mild) (bone normal) (speech_intell normal) (tymp_peak compliant) (tymp_pr normal) (contra_AR normal)
                     (ipsi_AR absent) (other_i_AR normal))
      :typicality   2
      :differences  ((case_1_2_N <- ( (ipsi_AR normal)))))

(term :name         case_7_2
      :category     facial_nerve_disorder
      :features     ((air normal) (other_i_AR normal) (bone normal) (speech_intell normal) (tymp_peak normal) (tymp_pr normal) (contra_AR normal)
                     (ipsi_AR absent) (other_c_AR absent) facial_paralysis)
      :typicality   1
      :differences  ( ))

(term :name         case_7_2_N
      :category     normal_ear
      :features     ((air normal) (bone normal) (speech_intell normal) (ipsi_AR normal) (contra_AR absent) (other_i_AR absent) (other_c_AR normal)
                     (tymp_pr normal) (tymp_peak normal))
      :typicality   1
      :differences  ( ))

(term :name         case_NKA
      :category     meniere_s
      :features     ((air mild) (other_i_AR normal) (bone mild) (speech_intell normal) (tymp_peak normal) (tymp_pr normal) (contra_AR normal)
                     (ipsi_AR elevated) (other_c_AR normal) fullness tinnitus)
      :typicality   1
      :differences  ( ))

(term :name         case_NKA_revised
      :category     meniere_s
      :features     ((air mild) (other_i_AR normal) (bone mild) (speech_intell mild) (tymp_peak normal) (tymp_pr normal) (contra_AR normal)
                     (ipsi_AR elevated) (other_c_AR normal) fullness tinnitus (slope_toward low) speech_distorted)
      :typicality   1
      :differences  ( ))

(term :name         case_NORMAL
      :category     normal_ear
      :features     ((air normal) (other_i_AR normal) (bone normal) (speech_intell normal) (tymp_peak normal) (tymp_pr normal) (contra_AR normal)
                     (ipsi_AR normal) (other_c_AR normal))
      :typicality   2
      :differences  ((noise_induced_1 <- ( notch_4k noise_exposure))
                     (case_1_3_m <- ( decay_AR (speech_intell rollover)))))

(term :name         noise_induced_1
      :category     noise_induced
      :features     ((air normal) (bone normal) (speech_intell normal) (tymp_peak normal) (tymp_pr normal) (contra_AR normal) noise_exposure
                     tinnitus notch_4k)
      :typicality   2
      :differences  ( ))

(predicate  :name    discontinuity)

(term       :name    ossicular_chain)

(term :name         (discontinuity ossicular_chain)
      :importances  (((other_c_AR abnormal) 0.5)
                     ((contra_AR absent) 0)
                     ((other_c_AR elevated) 0.25)
                     ((air mild) 0.25)
                     ((bone normal) 0.5)
                     ((speech_intell normal) 0.5)
                     ((tymp_peak compliant) 0.75)
                     ((tymp_pr normal) 0.25)
                     ((contra_AR normal) 0)
                     ((ipsi_AR absent) 0.25)
                     ((other_c_AR absent) 0.25)
                     ((other_i_AR normal) 0))
      :exemplars    (case_6_1_L case_6_2_L )
      :relations    ((((discontinuity ossicular_chain)  hasTypicalSpec conductive_HL) "ee" NIL)
                     (((discontinuity ossicular_chain) occasionally is required by (other_c_AR elevated)) "ee" NIL)
                     (((discontinuity ossicular_chain) strongly cooccurs with (tymp_peak compliant)) "ee" NIL)
                     (((discontinuity ossicular_chain) occasionally is required by (ipsi_AR absent)) "ee" NIL)))

(term :name         acoustic_neuroma
      :importances  ((facial_nerve_weakness 0.25)
                     (fullness 0.25)
                     ((contra_AR absent) 0.25)
                     (decay_tone 0.75)
                     ((other_c_AR absent) 0.25)
                     ((ipsi_AR absent) 0.25)
                     ((air mild) 0.25)
                     ((bone mild) 0.25)
                     ((contra_AR abnormal) 0.5)
                     ((ipsi_AR abnormal) 0.5)
                     ((air normal) 0)
                     ((other_i_AR normal) 0)
                     ((bone normal) 0)
                     ((speech_intell rollover) 0.75)
                     ((tymp_peak normal) 0)
                     ((tymp_pr normal) 0)
                     ((contra_AR elevated) 0.25)
                     ((ipsi_AR elevated) 0.25)
                     ((other_c_AR normal) 0)
                     (tinnitus 0.25)
                     (decay_AR 0.75))
      :exemplars    (case_1_2 case_1_1 case_1_3_m )
      :relations    (((acoustic_neuroma occasionally is required by facial_nerve_weakness) "ee" NIL)
                     ((acoustic_neuroma sometimes is required by fullness) "ee" NIL)
                     ((acoustic_neuroma strongly cooccurs with decay_tone) "ee" NIL)
                     ((acoustic_neuroma sometimes is required by (air mild)) "ee" NIL)
                     ((acoustic_neuroma sometimes is required by (bone mild)) "ee" NIL)
                     ((acoustic_neuroma usually cooccurs with (speech_intell rollover)) "ee" NIL)
                     ((acoustic_neuroma sometimes is required by (contra_AR elevated)) "ee" NIL)
                     ((acoustic_neuroma sometimes is required by (ipsi_AR elevated)) "ee" NIL)
                     ((acoustic_neuroma occasionally cooccurs with tinnitus) "ee" NIL)
                     ((acoustic_neuroma moderately cooccurs with decay_AR) "ee" NIL)))

(term :name         facial_nerve_disorder
      :importances  (((air normal) 0.5)
                     ((other_i_AR normal) 0.25)
                     ((bone normal) 0)
                     ((speech_intell normal) 0.25)
                     ((tymp_peak normal) 0)
                     ((tymp_pr normal) 0)
                     ((contra_AR normal) 0.5)
                     ((ipsi_AR absent) 0.5)
                     ((other_c_AR absent) 0.5)
                     (facial_paralysis 0.75))
      :exemplars    (case_7_2 )
      :relations    (((facial_nerve_disorder occasionally is required by (air normal)) "ee" NIL)
                     ((facial_nerve_disorder weakly is required by (speech_intell normal)) "ee" NIL)
                     ((facial_nerve_disorder sometimes is required by ((other_c_AR absent) and (ipsi_AR absent) and (contra_AR normal) and (other_i_AR normal))) "ee" NIL)
                     ((facial_nerve_disorder sometimes cooccurs with facial_paralysis) "ee" NIL)))

(term :name         malleus_fixation
      :importances  (((air severe) 0.5)
                     ((other_i_AR normal) 0)
                     ((bone normal) 0.75)
                     ((speech_intell normal) 0.25)
                     ((tymp_peak flat) 0.75)
                     ((tymp_pr negative) 0.5)
                     ((contra_AR absent) 0)
                     ((ipsi_AR absent) 0.5)
                     ((other_c_AR absent) 0.5)
                     (fullness 0.5))
      :exemplars    (case_13_1 )
      :relations    (((malleus_fixation  cooccurs with (otoscopy normal)) "ee" NIL)
                     ((malleus_fixation sometimes cooccurs with (air severe)) "ee" NIL)
                     ((malleus_fixation  cooccurs with (tymp_peak flat)) "ee" NIL)
                     ((malleus_fixation  hasTypicalSpec conductive_HL) "ee" NIL)))

(term :name         meniere_s
      :importances  (((speech_intell mild) 0.5)
                     ((slope_toward low) 0.75)
                     (speech_distorted 0.5)
                     ((air mild) 0.25)
                     ((bone mild) 0)
                     ((speech_intell normal) 0)
                     ((tymp_peak normal) 0)
                     ((tymp_pr normal) 0)
                     ((ipsi_AR elevated) 0.5)
                     (fullness 0.25)
                     ((air moderate) 0.25)
                     ((other_c_AR normal) 0)
                     ((ipsi_AR normal) 0.25)
                     ((contra_AR normal) 0)
                     ((other_i_AR normal) 0)
                     ((speech_intell moderate) 0.75)
                     (vertigo 0.5)
                     (nausea 0.5)
                     (vomiting 0.25)
                     (tinnitus 0.5))
      :exemplars    (case_NKA_revised case_NKA case_14_2H case_14_2A )
      :relations    (((meniere_s sometimes causedBy (speech_intell mild)) "ee" NIL)
                     ((meniere_s usually cooccurs with (slope_toward low)) "ee" NIL)
                     ((meniere_s sometimes causedBy speech_distorted) "ee" NIL)
                     ((meniere_s sometimes is required by (ipsi_AR elevated)) "ee" NIL)
                     ((meniere_s weakly is required by fullness) "ee" NIL)
                     ((meniere_s sometimes is required by (air moderate)) "ee" NIL)
                     ((meniere_s  hasTypicalSpec cochlear) "ee" NIL)
                     ((meniere_s sometimes is required by vertigo) "ee" NIL)
                     ((meniere_s sometimes is required by nausea) "ee" NIL)
                     ((meniere_s sometimes is required by vomiting) "ee" NIL)
                     ((meniere_s usually is required by tinnitus) "ee" NIL)))

(term :name         noise_induced
      :importances  (((air normal) 0)
                     ((bone normal) 0)
                     ((speech_intell normal) 0)
                     ((tymp_peak normal) 0)
                     ((tymp_pr normal) 0)
                     ((contra_AR normal) 0)
                     (noise_exposure 0.75)
                     (tinnitus 0.5)
                     (notch_4k 0.5))
      :exemplars    (noise_induced_1 )
      :relations    (((noise_induced  defimplies noise_exposure) "ee" NIL)
                     ((noise_induced usually cooccurs with tinnitus) "ee" NIL)
                     ((noise_induced sometimes cooccurs with notch_4k) "ee" NIL)))

(term :name         normal_ear
      :importances  (((contra_AR absent) 0)
                     ((other_i_AR absent) 0)
                     ((other_i_AR elevated) 0)
                     ((other_c_AR elevated) 0)
                     ((air normal) 0.5)
                     ((other_i_AR normal) 0.25)
                     ((bone normal) 0.25)
                     ((speech_intell normal) 0.25)
                     ((tymp_peak normal) 0.25)
                     ((tymp_pr normal) 0.25)
                     ((contra_AR normal) 0.25)
                     ((ipsi_AR normal) 0.5)
                     ((other_c_AR normal) 0.5))
      :exemplars    (case_7_2_N case_1_2_N case_NORMAL )
      :relations    (((normal_ear strongly is required by (air normal)) "ee" NIL)
                     ((normal_ear weakly is required by (other_i_AR normal)) "ee" NIL)
                     ((normal_ear weakly is required by (bone normal)) "ee" NIL)
                     ((normal_ear weakly is required by (speech_intell normal)) "ee" NIL)
                     ((normal_ear weakly is required by (tymp_peak normal)) "ee" NIL)
                     ((normal_ear weakly is required by (tymp_pr normal)) "ee" NIL)
                     ((normal_ear weakly is required by (contra_AR normal)) "ee" NIL)
                     ((normal_ear usually is required by (ipsi_AR normal)) "ee" NIL)
                     ((normal_ear moderately is required by (other_c_AR normal)) "ee" NIL)))

(term :name         otitis_media
      :importances  (((air abnormal) 0.25)
                     ((other_i_AR absent) 0.25)
                     ((air mild) 0.25)
                     ((bone normal) 0.5)
                     ((speech_intell normal) 0.5)
                     ((tymp_peak flat) 0.5)
                     ((tymp_pr negative) 0.5)
                     ((contra_AR absent) 0.25)
                     ((ipsi_AR absent) 0.5)
                     ((other_c_AR absent) 0.25)
                     ((other_i_AR abseent) 0))
      :exemplars    (case_17_1_R )
      :relations    (((otitis_media  hasTypicalSpec conductive_HL) "ee" NIL)
                     ((otitis_media moderately is required by (tymp_pr negative)) "ee" NIL)
                     ((otitis_media moderately is required by (ipsi_AR absent)) "ee" NIL)))
