
(defun prompt (prompt1 prompt2 type object view)
  (prog ((inputs nil)
	 input)
     REPROMPT
	(clear-input *query-io*)
	(consume-white-space)
	(format *query-io* prompt1)
	(if prompt2 (format *query-io* prompt2))
	(if (eql type 'y-or-n)
	    (princ "(Y or N) " *query-io*))

	(prog (c)
	   TOP
	      ;; If next character is the "?" escape character ...
	      (setq c (peek-char nil *query-io* nil 'eof))
	      (if (char= #\? c)
		  ;; then consume it and examine next character.
		  (prog (selection)
			(read-char *query-io* nil 'eof)
			(setq selection (read-char *query-io* nil 'eof))
			(if (or (char= #\Rubout selection)
				(char= #\Backspace selection))
			    (go TOP))
			(escape selection object view)
			(go REPROMPT)))
	      
	      (case type
		(explanation
		  (if (char= #\Newline c)
                     (progn
                      (format *query-io* "~% newline character found.")
		      (go OUT)))
		  (setq input (read-line *query-io* nil nil nil))
		  (cond
		    ((null input)
		     (go OUT))
		    ((not (listp input))
		     (format *query-io* "~%Error: an explanation must be a list,~
                                         ~%enclosed in parentheses: ")
		     (go REPROMPT))
		    ((null (first-pass input))
		     (go REPROMPT))))

		(otherwise
		  (if (char= #\Newline c)
		      (go OUT))
		  (format *query-io* "~%Illegal type \"~A\" given to prompt.~
                                      ~%Go ahead and enter input anyway.~%"
			  type)
		  (setq input (read *query-io* nil nil nil))))

	      (if (null prompt2)
		  (return-from prompt input))
	      (push input inputs)
	      (format *query-io* prompt2)
	      (go TOP))
	      
     OUT
	(return-from prompt (nreverse inputs))))

