structure Two_Queue : TWO_QUEUE =
struct
 type 'a queue = 'a list * 'a list * 'a list * 'a list

 fun isEmpty ([],[],[],[]) = true
   | isEmpty _ = false

 val empty = ([],[],[],[])

 fun enqueueHi (x,(front1,tail1,front2,tail2)) =
   (front1,x::tail1,front2,tail2)

 fun enqueueLo (x,(front1,tail1,front2,tail2)) =
   (front1,tail1,front2,x::tail2)

 fun dequeue (x::front1,tail1,front2,tail2) =
       (x,(front1,tail1,front2,tail2))
   | dequeue ([],[],x::front2,tail2) =
       (x,([],[],front2,tail2))
   | dequeue ([],[],[],tail2) =
     let val x::front2 = rev tail2
     in (x,([],[],front2,[])) end
   | dequeue ([],tail1,front2,tail2) =
     let val x::front1 = rev tail1
     in (x,(front1,[],front2,tail2)) end
end
